// util.cc,v 2.1 1995/06/19 19:04:50 andreas Exp

/*
**  jazz - a midi sequencer for Linux
**
**  Copyright (C) 1994 Andreas Voss (andreas@avix.rhein-neckar.de)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "util.h"
#include "song.h"

#include <ctype.h>


// *************************************************************************
// tNamedChoice
// *************************************************************************


tNamedChoice::tNamedChoice(char *t, tNamedValue *v, long *r)
{ 
  Values = v; 
  Selection = 0; 
  Title = t;  
  Result = r;
}



wxFormItem *tNamedChoice::mkFormItem(int w, int h)
{
  SetValue();

  // following adapted from wxwin/src/base/wb_form.cc
  wxList *list = new wxList;
  for (int i = 0; Values[i].Name; i++)
    if (*Values[i].Name)	// omit empty entries
      list->Append((wxObject *)copystring(Values[i].Name));

  wxFormItemConstraint *constraint = wxMakeConstraintStrings(list);
  return wxMakeFormString(Title, &Selection, wxFORM_SINGLE_LIST, new wxList(constraint, 0),
    0, 0, w, h);
}


void tNamedChoice::GetValue()
{
  int i;

  if (Selection)
  {
    for (i = 0; Values[i].Name; i++)
    {
      if (!strcmp(Selection, Values[i].Name))
      {
	*Result = Values[i].Value;
	break;
      }
    }
  }
}


void tNamedChoice::SetValue()
{
  int i;

  for (i = 0; Values[i].Name; i++)
  {
    if (*Result == Values[i].Value)
    {
      delete Selection;
      Selection = copystring(Values[i].Name);
      break;
    }
  }
}

tNamedChoice::~tNamedChoice()
{
  delete Selection;
}


// **********************************************************************
// tRect
// **********************************************************************


tRect::tRect(float xx, float yy, float ww, float hh)
{
  x = xx; y = yy; w = ww; h = hh;
}

void tRect::SetUnion(tRect &r)
{
  if (r.w > w)
    w = r.w;
  if (r.h > h)
    h = r.h;
}

void tRect::SetNormal()
{
  if (w < 0)
  {
    w = -w;
    x -= w;
  }
  if (h < 0)
  {
    h = -h;
    y -= h;
  }
}

// **************************************************************************
// tClockDlg
// **************************************************************************

tClockDlg::tClockDlg(tSong *s, char *t, long c) 
{
  char buf[500];
  s->Clock2String(c, buf);
  String = copystring(buf);
  Title = t;
  Song  = s;
}


tClockDlg::~tClockDlg()
{
  delete String;
}


wxFormItem *tClockDlg::mkFormItem()
{
  return wxMakeFormString(Title, &String, wxFORM_DEFAULT);
}



long tClockDlg::GetClock()
{
  return Song->String2Clock(String);
}

// ***********************************************************************
// KeyStr
// ***********************************************************************


void Key2Str(int key, char *str)
{
  static char *Names[] = { "C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B" };
  strcpy(str, Names[key % 12]);
  sprintf(str + strlen(str), "%d", key / 12);
}


int Str2Key(char *str)
{
  static char sKey[] = "cCdDeEfFgGaAbB";
  static int  nKey[]={0,0,2,2,4,4,5,5,7,7,9,9,11,11};
  int i, key = 0;

  while (*str)
  {
    if (*str == '#')
    {
      key += 1;
      str++;
    }
    else if (isdigit(*str))
    {
      int n = 0;
      while (isdigit(*str))
        n = 10 * n + *str++ - '0';
      key += 12 * n;
    }
    else
    {  
      for (i = 0; sKey[i]; i++)
      {
	if (str[0] == sKey[i])
	{
	  key += nKey[i];
	  str++;
	  break;
	}
      }
      if (!sKey[i])	// error
        ++ str;
    }
  }
  return key;
}

// **************************************************************************
// tNoteDlg
// **************************************************************************

tKeyDlg::tKeyDlg(char *t, int Key) 
{
  char buf[50];
  Key2Str(Key, buf);
  String = copystring(buf);
  Title = t;
}


tKeyDlg::~tKeyDlg()
{
  delete String;
}


wxFormItem *tKeyDlg::mkFormItem()
{
  return wxMakeFormString(Title, &String, wxFORM_DEFAULT);
}



int tKeyDlg::GetKey()
{
  return Str2Key(String);
}

