// eventwin.h,v 2.1 1995/06/19 19:04:41 andreas Exp

/*
**  jazz - a midi sequencer for Linux
**
**  Copyright (C) 1994 Andreas Voss (andreas@avix.rhein-neckar.de)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef eventwin_h
#define eventwin_h


#ifndef wx_wxh
#include "wx.h"
#endif

#ifndef maction_h
#include "maction.h"
#endif

#ifndef filter_h
#include "filter.h"
#endif

/* 
 * tEventWin
 * 
 * Ein Fenster mit Panel, Canvas, Scrollbars, Menus,
 * gemeinsame Basisklasse fuer TrackWin und PianoWin.
 * 
 * Panel,Menu wird von abgeleiteter Klasse verwaltet.
 * Funktionen
 *   - Settings dialog
 *   - Selection via Snapsel
 */

class tEventWin;
class tSong;

class tCanvas: public wxCanvas
{
  public:
    int What;	// What to Redraw, -1 = all
    tEventWin *EventWin;
    tCanvas(tEventWin *frame, int x, int y, int w, int h, int style = 0);
    void OnPaint(void);
    void OnEvent(wxMouseEvent& event);
    void OnChar(wxKeyEvent& event);
    void SetScrollRanges();
    void SetScrollPosition(long x, long y);
};



class tEventWin : public wxFrame
{

  public:

    // 2-stufige Initialisierung: 1) Konstruktor
    tEventWin(wxFrame *frame, char *title, tSong *song);
    ~tEventWin();

    tSong   *Song;
    tFilter *Filter;
    wxFrame *ParentWin;
    tEventWin *NextWin;


    // 2) Create():
    virtual void Create();
    virtual void CreateMenu();
    void CreateCanvas();
    tCanvas *Canvas;

    // Setup() 
    wxFont *Font;
    wxFont *FixedFont;	// bleibt bei 12pt
    int    hFixedFont;	// Hoehe eines Buchstaben

    long   LittleBit;
    long   hLine;

    long   hTop;
    long   wLeft;
    long   FontSize;
    long   ClocksPerPixel;
    Bool   UseColors;

    // Parameters changed, e.g. Song loaded
    virtual void Setup();

    // filled by OnPaint()
    wxDC *dc;
    long xEvents, yEvents, wEvents, hEvents;
    long xx, yy, ww, hh;	// canvas coords
    long FromClock, ToClock;
    long FromLine, ToLine;


    // Mousehandling
    tSnapSelection *SnapSel;
    tMouseAction *MouseAction;
    virtual void SnapSelStart(wxMouseEvent &e);
    virtual void SnapSelStop(wxMouseEvent &e);

    // methods
    long y2Line(long y, int up = 0);
    long y2yLine(long y, int up = 0);
    long Line2y(long line);
    void LineText(long x, long y, long w, char *str, int h = -1);
    long x2Clock(long x);
    long Clock2x(long clk);
    long x2BarClock(long x, int Next = 0);

    long    PlayClock;
    virtual void NewPlayPosition(long Clock);
    virtual void DrawPlayPosition();

    // sent by trackwin: scroll to Position
    virtual void NewPosition(int TrackNr, long Clock){} 

    // Events
    virtual void OnPaint(int What, long x, long y, long w, long h);
    virtual int  OnMouseEvent(wxMouseEvent &e);
    virtual int  OnKeyEvent(wxKeyEvent &e); // true = processed by eventwin
    virtual void OnSize(int w, int h);
    virtual void OnMenuCommand(int id);
    virtual Bool OnClose();

    // Redraw - nach Aenderungen von Parametern, kein GUI-Event
    virtual void Redraw(int What = -1);

    // Settings-Dialog
    wxDialogBox *DialogBox;
    void SettingsDialog(int piano);

    // Mixer-Dialog
    wxDialogBox *MixerForm;

    virtual void GetVirtSize(long *w, long *h);

    // Edit-Menu

    int EventsSelected();	// if selection active: TRUE, else: Errormessage + FALSE
    void MenQuantize();
    void MenSetChannel();
    void MenTranspose();
    void MenDelete();
    void MenVelocity();
    void MenLength();
    void MenMeterChange();

};


#endif
