// dialogs.h,v 2.1 1995/06/19 19:04:40 andreas Exp

/*
**  jazz - a midi sequencer for Linux
**
**  Copyright (C) 1994 Andreas Voss (andreas@avix.rhein-neckar.de)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef dialogs_h
#define dialogs_h

#ifndef eventwin_h
#include "eventwin.h"
#endif

/*
 * Dialogs haben static Parameter. Wenn ein Dialog mehrfach aufgerufen
 * wird, enthaelt die Dialogbox die Werte vom letzen mal
 */

// ***************************************************************************
// Menu-Funktionen
// ***************************************************************************

class tQuantizeDlg : public wxForm
{
  public:

    static Bool NoteStart;	// 1
    static Bool NoteLength;	// 0
    static int  QntStep;	// 1/16

    tFilter *Filter;
    tSong   *Song;

    long Quantize(long);

    tQuantizeDlg(tFilter *f);
    void EditForm(wxPanel *panel);
    void OnOk();
};

class tShiftDlg : public wxForm
{
  public:
    static int  Steps;	// 0
    long Unit;

    tFilter *Filter;
    tSong   *Song;

    tShiftDlg(tFilter *f, long Unit);
    void EditForm(wxPanel *panel);
    void OnOk();
};


// Transpose

class tTransposeDlg : public wxForm
{
  public:

    static int  Notes;	// 0
    static Bool FitIntoScale;
    static long Scale;

    tFilter *Filter;
    tSong   *Song;

    tNamedChoice ScaleDlg;
    tTransposeDlg(tFilter *f);
    void EditForm(wxPanel *panel);
    void OnOk();
};


// SetChannel

class tSetChannelDlg : public wxForm
{
  public:

    static int  NewChannel;	// 0

    tFilter *Filter;
    tSong   *Song;

    tSetChannelDlg(tFilter *f);
    void EditForm(wxPanel *panel);
    void OnOk();
};



// Velocity

class tVelocityDlg : public wxForm
{
  public:

    static int FromValue, ToValue, Mode;
    static char *mode_str;

    tFilter *Filter;
    tSong   *Song;

    tVelocityDlg(tFilter *f);
    void EditForm(wxPanel *panel);
    void OnOk();
};


// Length

class tLengthDlg : public wxForm
{
  public:

    static int FromValue, ToValue, Mode;
    static char *mode_str;

    tFilter *Filter;
    tSong   *Song;

    tLengthDlg(tFilter *f);
    void EditForm(wxPanel *panel);
    void OnOk();
};





class tDeleteDlg : public wxForm
{
  tFilter *Filter;

 public:
  static Bool LeaveSpace;	// 1

  tDeleteDlg(tFilter *f);
  void EditForm(wxPanel *panel);
  void OnOk();
};


// ***************************************************************************
// Einzel-Events
// **************************************************************************

class tEvent;
class tEventWin;
class tEventArray;

void EventDialog(tEvent *, tEventWin *, tTrack *, long Clock, int Channel, int Pitch);

#endif

