
/*
**  jazz - a midi sequencer for Linux
**
**  Copyright (C) 1994 Andreas Voss (andreas@avix.rni.sub.org)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * mpureg.h,v 2.0 1995/06/10 22:05:27 andreas Exp
 */
/* 
 * SunOS version by Per Sigmond (Per.Sigmond@hiagder.no)
 */

#ifndef MPU_H
#define MPU_H

struct mpuregs {
	char datareg; /* 330 */
	char cmdreg;  /* 331 */
};

#define MPU_WAIT 5000

#define MPU_BUFFER_SIZE 2000


#define MPU_TRACK   (0<<6)
#define MPU_DATA    (1<<6)
#define MPU_COMMAND (2<<6)
#define MPU_RESET   (3<<6)

#define ACTIVE_TRACKS 7

#include <sun386/cpu.h>

#define DISABLE_BUS_TIMEOUT (SYSCTRL = SYSCTRL & ~SCR_BUS_TMOUT)
#define ENABLE_BUS_TIMEOUT (SYSCTRL = SYSCTRL | SCR_BUS_TMOUT)

#endif

