#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <tcp.h>
#include "driver.h"
#include "mpu.h"
#include "midinetd.h"

#define MIDINET_PORT 40001

void main(int argc, char *argv[])
{
    longword remoteip;
    char *host;
    char dummyhost[80];


    char ch, buffer[ 80 ];
    word position;
    word sendit, status;
    int who_closed = 0;

    tcp_Socket s;

    char *m;
    int i;
    int sbytes, rbytes, mbytes;
    char b;
    word midinetport;

    if (argc > 1) {
	midinetport = atoi( argv[1] );
    }
    else {
	midinetport = MIDINET_PORT;
    }

    clrscr();

    sock_init();

    while (1) {
	cputs("MIDINETD");
	cputs("\n\r\nWaiting for an incoming call\n\r\n");
	cprintf("(My address is [%s+%u]\n\r", inet_ntoa( buffer, gethostid()), midinetport);
	tcp_listen( &s, midinetport, 0, 0, NULL, 0 );
	sock_mode( &s, TCP_MODE_BINARY );
	sock_wait_established( &s, 0, NULL, &status);
	cprintf("Connection established\r");

    	i=0x330;

    	switch(i=initialize_mpu(i)) {
        case 2:
        case 3:
        case 4:
        case 5:
        case 6:
        case 7:
            printf("\nThe MPU-401 is on interrupt %d\n", i);
            break;

        case 0:
            printf("\nThe MPU-401 was found but no interrupts were detected.\n");
            deinitialize_mpu();
            return;

        case -1:
            printf("\nThe MPU-401 failed to initialize!\n");
            printf("\nPlease turn off your computer to reset the MPU.\n\n");
            return;
    	}

    	printf("\nMPU-401 version is %x, revision %x.\n\n",
            send_command(REQUEST_VERSION),
            send_command(REQUEST_REVISION));

    	set_mpu_interrupt(mpu_interrupt);

    	who_closed = midinetd( &s );
	if (who_closed == -1) goto sock_err;

    	deinitialize_mpu();
    	if ( who_closed == 1 ) {
		cputs(" *** YOU CLOSED CONNECTION *** ");
		sock_wait_closed(&s, sock_delay, NULL, &status);
    	} else
		cputs(" *** CLIENT CLOSED CONNECTION *** ");

    	sleep( 1 );
    }
sock_err:
		sock_wait_closed(&s, sock_delay, NULL, &status);
}
