/* filedlg.c  acb  19-1-1995
 * XView file dialog
 * copyright (c) Andrew Bulhak 1995. Freely distributable.
 */

#include <dirent.h>
#include <sys/stat.h>
#include <xview/xview.h>
#include <xview/frame.h>
#include <xview/panel.h>
#include <xview/svrimage.h>

#include "file_glyph.xbm"
#include "dir_glyph.xbm"

extern Frame frame; /* the parent frame; crufty, I know... */

static Frame fdlg_frame=NULL;
static Panel_item files, parent_dirs, name, mask;

static Server_image file_glyph, dir_glyph;

static char cwd[1024];
int sel_mode=-1; /* the file mode of the selected entry */

void (*ok_callback)(char *);

/* determine if a string matches a glob wildcard */

static int match(char *str, char *wild)
{
  char *a, *b;
  /* check if start matches */
  a=str; b=wild;
  while((*b) && (*b != '*')) {
    if(*a != *b) return 0; /* fail */
    a++;
    b++;
  };
  /* check if end matches */
  a = str+strlen(str)-1;
  b = wild+strlen(wild)-1;
  while((a>=str) && (b>=wild) && (*b != '*')) {
    if(*a != *b) return 0;
    a--;
    b--;
  };
  return 1; /* sf, sg */
};

/* fill the listbox with files in the directory cwd */
void fill_files(char *name_mask)
{
  DIR *dir = opendir(cwd);
  struct dirent *dp;
  int i=0;

/*  fprintf(stderr, "fill_files(\"%s\") called.\n", name_mask);*/
  xv_set(files, PANEL_LIST_DELETE_ROWS, 0, 
	 (int)xv_get(files, PANEL_LIST_NROWS), NULL);
  xv_set(files, XV_SHOW, FALSE);
  while(dp=readdir(dir)) {
    struct stat stbuf;
    stat(dp->d_name, &stbuf);
    if((stbuf.st_mode & S_IFDIR) || match(dp->d_name, name_mask)) {
      xv_set(files, PANEL_LIST_INSERT, i,
	     PANEL_LIST_STRING, i, dp->d_name, 
	     PANEL_LIST_GLYPH, i, 
	     (stbuf.st_mode & S_IFDIR)?dir_glyph:file_glyph,
	     PANEL_LIST_CLIENT_DATA, i, stbuf.st_mode,
	     NULL);
      i++;
    };
  };
  closedir(dir);
  xv_set(files, XV_SHOW, TRUE);
};

static int ok_inhibit=0;

static void ok_func(Panel_item i, Event* e)
{
  if(!ok_inhibit)
    if(sel_mode & S_IFDIR) {
      /* is a directory; change to it */
      strcat(cwd, "/"); strcat(cwd, xv_get(name, PANEL_VALUE));
      chdir(cwd);
      ok_inhibit = 1;
      fill_files(xv_get(mask, PANEL_VALUE));
      ok_inhibit = 0;
    } else {
      /* is a file */
      xv_set(fdlg_frame, XV_SHOW, FALSE);
      (*ok_callback)(xv_get(name, PANEL_VALUE));
    };
};

static void quit_func(Panel_item i, Event* e)
{
  xv_set(fdlg_frame, XV_SHOW, FALSE);
};

static int files_notify(Panel_item item, char *str, Xv_opaque client_data,
			Panel_list_op op, Event *ev, int row)
{
  switch(op) {
  case PANEL_LIST_OP_VALIDATE: return XV_ERROR;
  case PANEL_LIST_OP_DELETE: return XV_ERROR;
  case PANEL_LIST_OP_SELECT: 
    xv_set(name, PANEL_VALUE, str, NULL);
    sel_mode = client_data;
  };
};

void do_filedlg(char *name_mask, void (*callback)(char *))
{
  Panel panel;
  ok_callback = callback;
  if(!fdlg_frame) {
    fdlg_frame = (Frame) xv_create(frame, FRAME_CMD,
				   FRAME_LABEL, "Open file",
				   XV_SHOW, FALSE,
				   NULL);
    panel = (Panel) xv_get(fdlg_frame, FRAME_CMD_PANEL);
    mask = (Panel_item) xv_create(panel, PANEL_TEXT,
				  PANEL_LABEL_STRING, "Mask:",
				  PANEL_VALUE_STORED_LENGTH, 8,
				  PANEL_VALUE_DISPLAY_LENGTH, 8,
				  PANEL_NEXT_ROW, -1,
				  PANEL_VALUE, name_mask, NULL);
    name = (Panel_item) xv_create(panel, PANEL_TEXT,
				  PANEL_LABEL_STRING, "Filename:",
				  PANEL_VALUE_DISPLAY_LENGTH, 32,
				  PANEL_VALUE, "", 
				  PANEL_NEXT_ROW, -1,
				  NULL);
    files = (Panel_item) xv_create(panel, PANEL_LIST, 
				   PANEL_LIST_DISPLAY_ROWS, 8,
				   PANEL_LIST_WIDTH, 240,
				   PANEL_NOTIFY_PROC, files_notify,
/*				   PANEL_LIST_ROW_HEIGHT, 16,*/
				   PANEL_NEXT_ROW, -1,
				   NULL);
    
    (void) xv_create(panel, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Ok",
		     PANEL_NOTIFY_PROC, ok_func,
		     PANEL_NEXT_ROW, -1,
		     NULL);
    (void) xv_create(panel, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Cancel",
		     NULL);
    window_fit(panel);
    window_fit(fdlg_frame);
    file_glyph = (Server_image) xv_create(NULL, SERVER_IMAGE,
					  XV_WIDTH, file_glyph_width,
					  XV_HEIGHT, file_glyph_height,
					  SERVER_IMAGE_BITS, file_glyph_bits,
					  NULL);
    dir_glyph = (Server_image) xv_create(NULL, SERVER_IMAGE,
					 XV_WIDTH, dir_glyph_width,
					 XV_HEIGHT, dir_glyph_height,
					 SERVER_IMAGE_BITS, dir_glyph_bits,
					 NULL);
  };
  getcwd(cwd, sizeof(cwd));
  fill_files(name_mask);
  xv_set(fdlg_frame, XV_SHOW, TRUE);
  
};
