
/* ===================================================================== */
/*		RadioReveal FM card - basic controls			 */
/*									 */
/*	7/1995 by Harawi	<alberto.vignani@pmn.it>		 */
/*	This program is free software - use it as you like		 */
/* ===================================================================== */

#include <unistd.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <asm/io.h>

/*
  frequency is defined in steps of 25 kHz
  but what is the meaning of the offset 0xf6c?
*/
#define FCODE(f)	((int)(((float)(f)-88.0)*40)+0xf6c)

/*
  put here the hardware base address of the card (0x20C or 0x30C)
  locations xxC thru xxE are never accessed; the card uses instead
  a word port at address xxF
*/
#ifndef RPORT
#define RPORT	0x20f
#endif

/*
  frequency presets
*/
int MemCh[10] = 
{
	FCODE(101.8),
	FCODE(98.2),
	FCODE(96.0),
	FCODE(107.7),
	FCODE(92.1),
	FCODE(94.1),
	FCODE(90.3),
	FCODE(95.8),
	FCODE(98.675),
	FCODE(98.2)
};


/* ===================================================================== */
/*
   output to card - data is sent in a serial fashion, from LSB to MSB
   0 is encoded as '1 1 3 3', 1 as '5 5 7 7'
*/

void r_out(int v,int n)
{
    while (n--) {
	if (v&1) {
	    outw (5,RPORT);
	    outw (5,RPORT);
	    outw (7,RPORT);
	    outw (7,RPORT);
	}
	else {
	    outw (1,RPORT);
	    outw (1,RPORT);
	    outw (3,RPORT);
	    outw (3,RPORT);
	}
	v>>=1;
    }
}


/* ===================================================================== */
/*
   data sent in sequence to the card:
	(to the 16-bit port)
	16-bit frequency, in 25kHz steps, offset by 98.7 MHz (0xf6c)
	8-bit value, unknown function, seems to be always 0xa0
	(to the 8-bit port)
	1-byte volume control: 0x88 to increase, 0x48 to decrease, else 0
	1-byte control: 0xc0 to turn off, else 0xc8
*/

void radioon(int ch,int p2)
{
    r_out(ch,16);
    r_out(p2,8);
    usleep(1000);
    outb(0,RPORT);
    usleep(50000);		/* IMPORTANT to avoid clicks */
    outb(0xc8,RPORT);
}


void radiooff(void)
{
    r_out(FCODE(88.0),16);
    r_out(0xa0,8);
    outb(0,RPORT);
    outb(0xc0,RPORT);
}


void volumeup(void)
{
    outb(0x88,RPORT);
    usleep(200000);
    outb(0xc8,RPORT);
}


void volumedn(void)
{
    outb(0x48,RPORT);
    usleep(200000);
    outb(0xc8,RPORT);
}


/* ===================================================================== */

int main(int argc,char *argv[])
{
 int v,n;
#ifndef linux
#error	I feel lost here
#endif
 double f;
 char *p;
 
    if (argc<2) return(1);
    p = argv[1];
    n = 0xa0;
    ioperm(RPORT,2,1);
    if (*p=='+') volumeup();
    else
    if (*p=='-') volumedn();
    else
    if (!strcmp("on",p)) radioon(MemCh[0],n);
    else
    if (!strcmp("off",p)) radiooff();
    else
    if (isdigit(*p)) {
    	if (sscanf(p,"%lf",&f)==1) {
    		if ((f>=88.0)&&(f<=108.0)) {
    		   radioon(FCODE(f),n);
    		}
    		else if ((f>0.99)&&(f<10.01)) {
    		   v=f;
    		   radioon(MemCh[v-1],n);
    		}
    	}
    }
    ioperm(RPORT,2,0);
    return(0);
}


