/*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*
 * misc.c -
 *    Miscellenous functions for cdplayer.   
\*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*/

#include   <stdlib.h>
#include   <stdio.h>
#include   <stdarg.h>
#include   <sys/types.h>
#include   <sys/time.h>
#include   <signal.h>
#include   <unistd.h>
#include   <termios.h>
#include   <mntent.h>
#include   <getopt.h>
#include   <string.h>
#include   <ncurses.h>

#include   "misc.h"


/*=========================================================================
 * Static Debug Variables
\*=========================================================================*/
/* SOURCE__FILE; */


/*=========================================================================
 * Start of Code
\*=========================================================================*/


/* Copy into a malloced string. */
void   strmcpy (char **t, char *s)
{
    if (*t != NULL)
        free (*t);

    *t = malloc (strlen (s) + 1);
    if (*t == NULL) {
        perror ("strmcpy");
        myExit (1);
    }
    (void) strcpy (*t, s);
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 * NCurses init/terminate and exit.
\*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/


static BOOL      fNCursesActive;

void      exit_ncurses( void )
{
    if  ( fNCursesActive )
	endwin();

    fNCursesActive = FALSE;
}


void      init_ncurses( void )
{
    initscr();
    fNCursesActive = TRUE;
 
    if  ( COLS < 60 ) {
        fprintf( stderr, "ERROR: screen too narrow\n" );
	myExit( -1 );
    }

    cbreak();
    raw();
    noecho();

    keypad( stdscr, TRUE );
}


void    myExit( int   code )
{
    exit_ncurses();
    exit( code );
}


/*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*
 *     
 * misc.c - End of File
\*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*/
