/*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*
 * display.h -
 *     
\*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*/

#ifndef  __display__H
#define  __display__H

typedef struct {
    WINDOW           * pwTOC;
    WINDOW           * pwMessage;
    struct cdinfo    * pCD;
    int                scrStartTrack, cur_track; 
    BOOL               fFollowMode;
    int                cdLines;
    char               szMessage[ 200 ];
} displayInfoType;


int       cursesSmartPrint( WINDOW    * pw,
		        int         y,
		        int         x,
		        char      * str, 
		        char        ch, 
		        chtype      regColor,
		        chtype      hiColor );
void      displayControlPanel( displayInfoType       * pInfo );
void      displayInitInfo( displayInfoType       * pInfo,
  			   struct cdinfo         * pCD );
int       displayStatusPrintf( displayInfoType       * pInfo, 
		 	       char                  * fmt, ...);
void      displayClearScreen( displayInfoType       * pInfo );

void      displayEditCurrSongName( displayInfoType      * pInfo );
void      displayEditArtistName( displayInfoType      * pInfo );
void      displayEditCDName( displayInfoType      * pInfo );


#else   /* __display__H */
#error  Header file display.h included twice
#endif  /* __display__H */

/*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*
 *     
 * display.h - End of File
\*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*/
