#
# Config file to build on Linux
#
# @(#)config-linux.mk	1.1 01/05/94

# --------------------------------------------------------------------
# |  Please see the file ``config-default.mk'' in this directory!    |
# --------------------------------------------------------------------
include $(ROOT)/mk/config-default.mk

include $(ROOT)/mk/config-g++.mk

#
# Programs to use
#
RANLIB = 	ranlib
CC =		gcc
LINUXDEF =	-Dlinux -Dsun -D_GNU_SOURCE -D_BSD_SOURCE
OPTIMIZER =	-O2 -m486 -fomit-frame-pointer -pipe
WARNINGS =	-Wall -Wcast-qual -Wcast-align
GPPFLAGS =	$(LINUXDEF) $(WARNINGS) $(OPTIMIZER) $(MEMLOG)
CFLAGS =	$(LINUXDEF) $(OPTIMIZER) -fwritable-strings

#
# Directories to use
#
X11_INCSPEC = -I/usr/X386/include/X11
X11INCL     = -I/usr/X386/include/X11
X11_LIBSPEC = -L/usr/X386/lib/X11 -lX11

# Flag that cc expects to create statically linked binaries.
# Binaries that are shipped should be statically linked.
# Note that currently vem is built with cc, not gcc, so vem uses
# this flag. See also config-g++.mk
CC_STATIC = -static

#S56DIR= $(ROOT)/vendors/s56dsp
S56DIR=
