/*
   COPYB.I
   Utility to copy binary files.

   $Id: copyb.i,v 1.1 1993/08/27 18:50:06 munro Exp $
 */
/*    Copyright (c) 1994.  The Regents of the University of California.
                    All rights reserved.  */

func copyb(src, dst, size=)
/* DOCUMENT copyb, src, dst
         or copyb, openb(src_name), createb(dst_name)
     Copy binary file SRC to binary file DST.
     Check for "obsolete/" subdirectory of Yorick home directory for
     extensions of the openb function to old file formats.
     Use the size= keyword to specify a non-default (4 Mbbyte) size for
     the members of the outpu file family.
   SEE ALSO: openb, createb, open102, close102
 */
{
  vars= get_vars(src);

  /* declare and copy non-record variables */
  names= *vars(1);
  n= numberof(names);
  for (i=1 ; i<=n ; i++) {
    name= names(i);
    value= get_member(src, name);
    add_variable, dst, -1, name, structof(value), dimsof(value);
    get_member(dst, name)= value;
    value= [];
  }

  names= *vars(2);
  n= numberof(names);
  if (n<1) return;

  /* declare record variables */
  add_record, dst;
  for (i=1 ; i<=n ; i++) {
    name= names(i);
    add_variable, dst, -1, name, structof(get_member(src, name)), \
      dimsof(get_member(src, name));
  }

  if (size) set_filesize, dst, size;

  /* copy record variables for each record */
  times= get_times(src);
  ncycs= get_ncycs(src);
  time= ncyc= [];
  r= 1;
  if (!is_void(times)) jt, src, times(1);
  else {
    while (jt(src,-));
    jt, src;
  }
  do {
    if (!is_void(times)) time= times(r);
    if (!is_void(ncycs)) ncyc= ncycs(r);
    add_record, dst, time, ncyc, -1;
    for (i=1 ; i<=n ; i++) {
      name= names(i);
      get_member(dst, name)= get_member(src, name);
    }
    r++;
  } while (jt(src));
}
