//-------------------------------------------------------------------//

// Synopsis: Median value

// Syntax:   median ( X )

// Description:

//      median computes the median (middle) value for the input
//      vector/matrix X. If X is a vector, then a single value is
//      returned. If X is a matrix, then a row-vector of the median
//      values for each column is returned.

//-------------------------------------------------------------------//

median = function ( x )
{
  local (x)

  m = x.nr;
  n = x.nc;

  x = sort(x).val;
  
  if (m == 1)                     // Row-vector
  {
    if (mod(n,2))                 // n is odd
    {
      y = x[(n+1)/2];
    else                          // n is even
      y = (x[n/2] + x[n/2+1])/2;
    }
  else                            // Column Vector / Matrix
    if (mod(m,2))                 // m is odd
    {
      y = x[(m+1)/2;];
    else                          // m is even
      y = (x[m/2;] + x[m/2+1;])/2;
    }
  }
  return y;
};
