//-------------------------------------------------------------------//
// Synopsis:    Next integer power of 2.

// Usage:       nextpow2 ( N )

// Description:

//      nextpow2 returns the first integer such tht 2^P >= N. If N is
//      a vector, then nextpow2 computes P such that 2^P >= length(N).

// See Also: frexp

//-------------------------------------------------------------------//

nextpow2 = function ( n )
{
  local (n)

  if (length (n) > 1) 
  {
    n = length (n);
  }

  </ e ; f /> = frexp (abs(n));
  
  //
  // If e == 0.5, then the exponent is 1 > than the value we want.
  //

  if (f == 0.5)
  {
    e = e - 1;
  }

  return e;
};
