//-------------------------------------------------------------------//
//
//  Syntax:	linspace ( s1 , s2 )
//		linspace ( s1 , s2 , n )

//  Description:

//  Linspace generates a linearly spaced vector. linspace(s1, s2)
//  generates a vector of 100 equally spaced points between s1 and
//  s2. linspace(s1, s2, n) generates n equally spaced points between
//  s1 and s2.

//-------------------------------------------------------------------//


linspace = function ( s1 , s2, n ) 
{
  if (!exist (n)) { n = 100; }
  if (n < 2) { error ("linspace: N must be >= 2"); }
  return [s1+(0:n-2)*(s2-s1)/(n-1), s2];
};
