/*--------------------------------------------------------------*/
/*	DecWindows Driver 1.0 , for GLE V3.0	         	*/
/*--------------------------------------------------------------*/
/*  	NOTE: MUST be run from a DECwindow (vt100 window, or curses) 	*/
/*---------------------------------------------------------------------------*/
#include "all.h"
#include <math.h>
#include "core.h"
#include "mygraph.h"
#include "mydev.h"
extern int gunit;
extern struct gmodel g;
/*---------------------------------------------------------------------------*/

void path_move(int x, int y);
void path_line(int x, int y);
void path_close(void);
void path_fill(void);
void path_newpath(void);
void path_stroke(void);

/*---------------------------------------------------------------------------*/
/* 		XWindows stuff here 		*/
/*-----------------------------------------------*/

/* Usage of backingstore should be *Always* safe now.... */
#ifndef NOBACKINGSTORE
   #define BACKINGSTORE
#endif

#ifdef VMS
#include <decw$include/Xlib.h>
#include <decw$include/Xutil.h>
#else
#ifdef aix
#define NeedFunctionPrototypes 0
#endif
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#endif

#define FontName "-ADOBE-NEW CENTURY SCHOOLBOOK-MEDIUM-R-NORMAL--*-140-*-*-P-*"
#define WindowName "CGLE Output"
int maxxsize;
int maxysize;
int window1W;
int window1H;
Display *dpy;
Window window1;
GC gc,gcf;
Screen *screen;
int doesbackingstore;
static void doInitialize();
static int  doDefineColor(int n);
static void doCreateWindows();
static void doCreateGraphicsContext();
static void doLoadFont();
static void doExpose();
static void doWMHints();
static void doMapWindows();
static void openDisplay();

/*
static void doHandleEvents();
static void doButtonPress();
*/

/******************** openDisplay ******************************************/

static void openDisplay()
{
    dpy = XOpenDisplay(0);
    if (dpy == NULL){
        gle_abort("Display not opened!\n");
	scr_end();
    }
    screen = XDefaultScreenOfDisplay(dpy);
    doesbackingstore = DoesBackingStore(screen);
}

/***************** doInitialize **************************/
int color_table[10];				/* a.r. 10 instead of 9 */
static void doInitialize()
{
    int i;

    openDisplay();
    doCreateWindows();

    for (i=0;i<=9; i++) {
	color_table[i] = doDefineColor(i);
    }

    doCreateGraphicsContext();

    XSync(dpy,False);

    doLoadFont();
    doWMHints();
    doMapWindows();
}

/******* doCreateWindows *********/
static void doCreateWindows()
{
    int window1X = (XWidthOfScreen(screen)-window1W);
    int window1Y = 1;
    XSetWindowAttributes xswa;
    unsigned long CW;

    /* Create the window1 window   width and height are global variables*/

    xswa.event_mask = ExposureMask | ButtonPressMask | KeyPressMask
			| VisibilityChangeMask;

    xswa.background_pixel = doDefineColor(0);
#ifdef BACKINGSTORE
    if (doesbackingstore){
       xswa.backing_store = Always;
       CW = CWEventMask | CWBackPixel  | CWBackingStore;
    }
    else
       CW = CWEventMask | CWBackPixel;
#else
       CW = CWEventMask | CWBackPixel;
#endif

    window1 = XCreateWindow(dpy,
			    XRootWindowOfScreen(screen),
			    window1X, window1Y, 
			    window1W, window1H,
			    0,
			    XDefaultDepthOfScreen(screen), 
			    InputOutput,
			    XDefaultVisualOfScreen(screen),
			    CW,
			    &xswa);
}


/******** Create the graphics context *********/
static void doCreateGraphicsContext()
{
    XGCValues xgcv;

    /* Create graphics context. */

    xgcv.background = doDefineColor(0);
    xgcv.foreground = doDefineColor(1);

    gc  = XCreateGC(dpy, window1, GCForeground | GCBackground, &xgcv);
    gcf = XCreateGC(dpy, window1, GCForeground | GCBackground, &xgcv);
}
setcolor(i)
{
    XGCValues xgcv;
    xgcv.foreground = color_table[i];
    XChangeGC(dpy, gc, GCForeground , &xgcv);
}
setfillcolor(i)
{
    XGCValues xgcv;
    xgcv.foreground = color_table[i];
    XChangeGC(dpy, gcf, GCForeground , &xgcv);
}

setfillstyle(i)
{
#define BM_WIDTH	16
#define BM_HEIGHT	16
Pixmap bm;
unsigned char bm_bits[][32] = {
{  0x00, 0x80, 0x00, 0x40, 0x00, 0x20, 0x00, 0x10, 0x00, 0x08, 0x00, 0x04,
   0x00, 0x02, 0x00, 0x01, 0x80, 0x00, 0x40, 0x00, 0x20, 0x00, 0x10, 0x00,
   0x08, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00},  /* SHADE    */ 
{  0x11, 0x11, 0x88, 0x88, 0x44, 0x44, 0x22, 0x22, 0x11, 0x11, 0x88, 0x88,
   0x44, 0x44, 0x22, 0x22, 0x11, 0x11, 0x88, 0x88, 0x44, 0x44, 0x22, 0x22,
   0x11, 0x11, 0x88, 0x88, 0x44, 0x44, 0x22, 0x22},  /* SHADE  1 */
{  0x01, 0x01, 0x80, 0x80, 0x40, 0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08,
   0x04, 0x04, 0x02, 0x02, 0x01, 0x01, 0x80, 0x80, 0x40, 0x40, 0x20, 0x20,
   0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x02},  /* SHADE  2 */
{  0x33, 0x33, 0x99, 0x99, 0xcc, 0xcc, 0x66, 0x66, 0x33, 0x33, 0x99, 0x99,
   0xcc, 0xcc, 0x66, 0x66, 0x33, 0x33, 0x99, 0x99, 0xcc, 0xcc, 0x66, 0x66,
   0x33, 0x33, 0x99, 0x99, 0xcc, 0xcc, 0x66, 0x66},  /* SHADE  3 */
{  0x07, 0x07, 0x83, 0x83, 0xc1, 0xc1, 0xe0, 0xe0, 0x70, 0x70, 0x38, 0x38,
   0x1c, 0x1c, 0x0e, 0x0e, 0x07, 0x07, 0x83, 0x83, 0xc1, 0xc1, 0xe0, 0xe0,
   0x70, 0x70, 0x38, 0x38, 0x1c, 0x1c, 0x0e, 0x0e},  /* SHADE  4 */
{  0x0f, 0x0f, 0x87, 0x87, 0xc3, 0xc3, 0xe1, 0xe1, 0xf0, 0xf0, 0x78, 0x78,
   0x3c, 0x3c, 0x1e, 0x1e, 0x0f, 0x0f, 0x87, 0x87, 0xc3, 0xc3, 0xe1, 0xe1,
   0xf0, 0xf0, 0x78, 0x78, 0x3c, 0x3c, 0x1e, 0x1e},  /* SHADE  5 */
{  0x01, 0x80, 0x02, 0x40, 0x04, 0x20, 0x08, 0x10, 0x10, 0x08, 0x20, 0x04,
   0x40, 0x02, 0x80, 0x01, 0x80, 0x01, 0x40, 0x02, 0x20, 0x04, 0x10, 0x08,
   0x08, 0x10, 0x04, 0x20, 0x02, 0x40, 0x01, 0x80},  /* GRID     */
{  0x01, 0x01, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x28, 0x28,
   0x44, 0x44, 0x82, 0x82, 0x01, 0x01, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28,
   0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x82, 0x82},  /* GRID   1 */
{  0x01, 0x01, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x28, 0x28,
   0x44, 0x44, 0x82, 0x82, 0x01, 0x01, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28,
   0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x82, 0x82},  /* GRID   2 */
{  0x83, 0x83, 0xc6, 0xc6, 0x6c, 0x6c, 0x38, 0x38, 0x38, 0x38, 0x6c, 0x6c,
   0xc6, 0xc6, 0x83, 0x83, 0x83, 0x83, 0xc6, 0xc6, 0x6c, 0x6c, 0x38, 0x38,
   0x38, 0x38, 0x6c, 0x6c, 0xc6, 0xc6, 0x83, 0x83},  /* GRID   3 */
{  0x03, 0xc0, 0x06, 0x60, 0x0c, 0x30, 0x18, 0x18, 0x30, 0x0c, 0x60, 0x06,
   0xc0, 0x03, 0x80, 0x01, 0xc0, 0x03, 0x60, 0x06, 0x30, 0x0c, 0x18, 0x18,
   0x0c, 0x30, 0x06, 0x60, 0x03, 0xc0, 0x01, 0x80},  /* GRID   4 */
{  0x03, 0xc0, 0x07, 0xe0, 0x0e, 0x70, 0x1c, 0x38, 0x38, 0x1c, 0x70, 0x0e,
   0xe0, 0x07, 0xc0, 0x03, 0xc0, 0x03, 0xe0, 0x07, 0x70, 0x0e, 0x38, 0x1c,
   0x1c, 0x38, 0x0e, 0x70, 0x07, 0xe0, 0x03, 0xc0}   /* GRID   5 */
};

    bm = XCreateBitmapFromData(dpy,window1,bm_bits[i],BM_WIDTH,BM_HEIGHT);
    XSetStipple(dpy, gcf, bm);
    XSetFillStyle(dpy, gcf, FillStippled);
    XFreePixmap(dpy, bm);
}


/******* Load the font for text writing ******/
static void doLoadFont()
{
    Font font;

    font = XLoadFont(dpy, FontName);
    XSetFont(dpy, gc, font);
}

/******* Create color ************************/
static int doDefineColor(int i)
{
    int pixel;
    char *colors[] = {
	"white",
	"black",
	"red",
	"green",
	"blue",
	"yellow",
	"magenta",
	"cyan",
	"light grey",
	"dim grey"				/* a.r. instead of black */
	};
    XColor exact_color,screen_color;
    if ((XDefaultVisualOfScreen(screen))->class == PseudoColor
        ||  (XDefaultVisualOfScreen(screen))->class == DirectColor)
        if (XAllocNamedColor(dpy, XDefaultColormapOfScreen(screen),
            colors[i], &screen_color, &exact_color))
                return screen_color.pixel;
            else
	        printf("Color not allocated! {%s}\n",colors[i]);
     else
        switch (i) {
            case 0:		return XWhitePixelOfScreen(screen); break;
	    case 1:		return XBlackPixelOfScreen(screen); break;
            default:		return XBlackPixelOfScreen(screen); break;
        }
}

/******** do WMHints *************/
static void doWMHints()
{
    XSizeHints xsh;

    /* Define the size and name of the window1 window */

    xsh.x = XWidthOfScreen(screen)-window1W;
    xsh.y = 1;
    xsh.width  = xsh.min_width  = xsh.max_width  = window1W;
    xsh.height = xsh.min_height = xsh.max_height = window1H;
    xsh.flags = PSize | PMinSize | PMaxSize | PPosition | USPosition;

    XSetNormalHints(dpy, window1, &xsh);

    XStoreName(dpy, window1, WindowName);
}
/******** doMapWindows ***********/
static void doMapWindows()
{
	set_expose();
	XMapWindow(dpy, window1);
}

getmaxx()
{
	return XHeightOfScreen( screen );			/* a.r. */
}
getmaxy()
{
	return (XHeightOfScreen( screen ) * 0.95 );		/* a.r. */
	/* how do I query the height of a titlebar from the Window Manager ? */
}
getmaxcolor()
{
	return 10;				/* a.r. 10 instead of 9 */
}
/*---------------------------------------------------------------------------*/

#define DASHED_LINE 2
#define SOLID_LINE 1
#define pi 3.141592653
#define BLACKANDWHITE 1
#define false 0
#define true (!false)
#define dbg if ((gle_debug & 64)>0)

double savexsize,saveysize;
extern int gle_debug;
int gle_nspeed = 2; /* text mode = slow and fast */
int incap=true;
/*---------------------------------------------------------------------------*/
/* The global variables for the PC screen driver */
/*-----------------------------------------------*/
int i,l,j,ix,iy;
double f;
double xsizecm,ysizecm;
#define sx(v) ( (int) ((v) * d_xscale))
#define sy(v) ( d_maxy - ((int) ((v) * d_yscale)))
#define rx(v) ( (int) ((v) * d_xscale))
#define ry(v) ( d_maxy - ((int) ((v) * d_yscale)))

double d_scale, d_xscale, d_yscale;
int d_graphmode;
int d_fillstyle=1,d_fillcolor;
int d_lstyle,d_lwidth;
int d_maxy;

d_devcmd(char *s)
{}
dxy(double x, double y, int *dx, int *dy)
{
	static double fx,fy;
	g_dev(x,y,&fx,&fy);
	*dx = sx(fx);
	*dy = sy(fy);
}

rxy(double x, double y, int *dx, int *dy)
{
	static double fx,fy,zx,zy;
	g_dev(x,y,&fx,&fy);
	g_dev(0.0,0.0,&zx,&zy);
	*dx = (int) ( (fx-zx) * d_xscale);
	*dy = (int) ( (fy-zy) * d_yscale);
}

/* short for XFillPolygon() */
dxy_short(double x, double y, short *dx, short *dy)
{
	static double fx,fy;
	g_dev(x,y,&fx,&fy);
	*dx = sx(fx);
	*dy = sy(fy);
}
rxy_short(double x, double y, short *dx, short *dy)
{
	static double fx,fy,zx,zy;
	g_dev(x,y,&fx,&fy);
	g_dev(0.0,0.0,&zx,&zy);
	*dx = (int) ( (fx-zx) * d_xscale);
	*dy = (int) ( (fy-zy) * d_yscale);
}

/*---------------------------------------------------------------------------*/
d_dfont(char *c)
{
	/* only used for the DFONT driver which builds fonts */
}
/*---------------------------------------------------------------------------*/
static char lastline[80];
d_message(char *s)
{
	w_message(s);
}
/*---------------------------------------------------------------------------*/
d_source(char *s)
{
	s=s;
}
/*---------------------------------------------------------------------------*/
d_get_type(char *t)
{
	strcpy(t,"INTERACTIVE, X, DECWINDOWS, XWINDOWS");
}
/*---------------------------------------------------------------------------*/
d_set_path(int onoff)
{}
/*---------------------------------------------------------------------------*/
d_newpath()
{
	path_newpath();
}
/*---------------------------------------------------------------------------*/
d_open(double width, double height)
{
	gle_nspeed = 2; /* text mode = slow and fast */
	xsizecm = 16;
	ysizecm = 16*0.95;
	/* Get largest rectangle we can fit on the screen */
	d_scale = xsizecm / width;
	f = ysizecm / height;
	if (f<d_scale) d_scale = f;
	if (dpy==NULL) 
		openDisplay();
	d_xscale = d_scale * (getmaxx()) / xsizecm; /* Device Scale X, Device Scale y */
	d_yscale = d_scale * (getmaxy()) / ysizecm;
    	window1W = width*d_xscale;
    	window1H = height*d_yscale;
	d_maxy = window1H;
	if (dpy==NULL || savexsize != width || saveysize != height) {
		if (dpy != NULL) 
                   {
                     if (window1 != 0)
                        {
			 XUnmapWindow(dpy, window1);
			 XDestroyWindow(dpy, window1);
                        }
			XCloseDisplay(dpy);
                   }
		openDisplay();
		doInitialize();
		set_expose();
		XRaiseWindow(dpy, window1);
		wait_expose();
	} else {
		set_expose();
		XRaiseWindow(dpy, window1);
#ifndef BACKINGSTORE						/* a.r. */
		wait_expose();
#else
                if (!doesbackingstore)
                   wait_expose();
#endif
	}
    	XClearWindow(dpy, window1);
	XSync(dpy,False);
	savexsize = width;
	saveysize = height;
}
/*---------------------------------------------------------------------------*/
d_tidyup()
{
}
d_close()
{
	int32 emask;
	XEvent ereturn;
        Window rr, cr;
        int rx, ry, cx, cy;
        unsigned int retmask;
        
	g_flush();
	lastline[0] = 0;
	XSync(dpy,False);
	
   	XQueryPointer(dpy, window1, &rr, &cr, &rx, &ry, &cx, &cy, &retmask);
   	if ( cx >= 0 &&  cx <= window1W && cy >= 0 &&  cy <= window1H )
           {
            fner("Picture completed, press any key or click mouse in the graphics window        ");
            scr_refresh();

            emask = ButtonPressMask | KeyPressMask;
            XWindowEvent(dpy, window1, emask, &ereturn);
           }
        else
           {
            fner("Picture completed, press RETURN to continue                    (Press any key)");
            scr_refresh();

            text_inkey(); 
           }
	XLowerWindow(dpy, window1);
        XSync(dpy,True);
}
/*---------------------------------------------------------------------------*/
d_set_line_cap(int i)
{
   /*  lcap, 0= butt, 1=round, 2=projecting square */
/* if X11 would do the same as Postscript......
   XGCValues xgcv;
   
   xgcv.cap_style = i+1;
   XChangeGC(dpy, gc,  GCCapStyle , &xgcv);
   XChangeGC(dpy, gcf, GCCapStyle , &xgcv);
*/
}
/*---------------------------------------------------------------------------*/
d_set_line_join(int i)
{
   /* 0= mitre, 1=round, 2=bevel */
/* if X11 would do the same as Postscript......
   XGCValues xgcv;
   
   xgcv.join_style = i;
   XChangeGC(dpy, gc,  GCJoinStyle, &xgcv);
   XChangeGC(dpy, gcf, GCJoinStyle, &xgcv);
*/
}
/*---------------------------------------------------------------------------*/
d_set_line_miterlimit(double d)
{
	i++;
}
/*---------------------------------------------------------------------------*/
d_set_line_width(double w)
{
	int xa,xb;
	XGCValues xgcv;
	rxy(w,w,&xa,&xb);
	rxy(w,w,&xa,&xb);
	xa = abs(xa);
    	xgcv.line_width = xa;
    	XChangeGC(dpy, gc, GCLineWidth , &xgcv);
}
/*---------------------------------------------------------------------------*/
d_set_line_styled(double dd)
{}
d_set_line_style(char *s)
{
	XGCValues xgcv;
        char *defline[] = {"", "", "12", "41", "14", "92", "1282", "9229",
                	   "4114", "54"};
	int i, dashoff=0;
	char dashlist[64];

	if (strlen(s)==1)  s = defline[*s-'0'];
	if (strcmp(s,"")==0) {
	    xgcv.line_style  = LineSolid;
	    XChangeGC(dpy, gc, GCLineStyle , &xgcv);
	} else {
	    xgcv.line_style  = LineDoubleDash;
	    XChangeGC(dpy, gc, GCLineStyle , &xgcv);
	    for (i=0; *s!=0; s++,i++)
		dashlist[i] = *s-'0' ? *s-'0' : 1;
	    XSetDashes(dpy, gc, dashoff, dashlist, i);
	}
}
/*---------------------------------------------------------------------------*/
int in_font;
d_fill()
{
	if (in_font)
		path_stroke();
	else
		path_fill();
}
/*---------------------------------------------------------------------------*/
d_fill_ary(int nwk,double (*wkx)[],double (*wky)[])
{
	int i;
/*	fprintf(psfile,"%g %g moveto \n",(*wkx)[0],(*wky)[0]);
	for (i=1;i<nwk;i++)
		fprintf(psfile,"%g %g l \n",(*wkx)[i],(*wky)[i]);
*/
}
d_line_ary(int nwk,double (*wkx)[],double (*wky)[])
{
	int i;
	dxy( (*wkx)[0], (*wky)[0], &ix, &iy);
/*	moveto(ix,iy); */
	for (i=1;i<nwk;i++) {
		dxy( (*wkx)[i], (*wky)[i], &ix, &iy);
	}
}
/*---------------------------------------------------------------------------*/
d_stroke()
{
	path_stroke();
}
/*---------------------------------------------------------------------------*/
d_clip()
{
}
/*---------------------------------------------------------------------------*/
d_set_matrix(double newmat[3][3])
{
}
/*---------------------------------------------------------------------------*/
d_move(double zx,double zy)
{
}
/*---------------------------------------------------------------------------*/
d_reverse() 	/* reverse the order of stuff in the current path */
{
}
/*---------------------------------------------------------------------------*/
d_closepath()
{
	if (g.inpath==true) {
		path_close();
		return;
	}
	g_line(g.closex,g.closey);
}
/*---------------------------------------------------------------------------*/
d_line(double zx,double zy)
{
	static int ux,uy;
	dxy(g.curx,g.cury,&ux,&uy);
	dxy(zx,zy,&ix,&iy);
	if (g.inpath==true) {
		if (!g.xinline) path_move(ux,uy);
		path_line(ix,iy);
		return;
	}
    	XDrawLine(dpy,window1,gc,ux,uy,ix,iy);
}
/*---------------------------------------------------------------------------*/
d_clear()
{
}
/*---------------------------------------------------------------------------*/
d_flush()
{
}
/*---------------------------------------------------------------------------*/
int polar_xy(double r, double angle, double *dx, double *dy);
int xy_polar(double dx,double dy,double *radius,double *angle);

#ifdef OLDARC /* draws weird things */
d_arcto(dbl x1,dbl y1,dbl x2,dbl y2,dbl rrr)
{
	double x0,y0,r1,a1,r2,a2,r3,a3,a4,r5,ssx,ssy,ex,ey;
	double bx1,by1,bx2,by2,dist,neg;
	g_get_xy(&x0,&y0);
	xy_polar(x1-x0,y1-y0,&r1,&a1);
	xy_polar(x2-x1,y2-y1,&r2,&a2);
	neg = 1;
	a4 = (180-a2+a1);
	a3 = a2 + (a4/2);
	if ((a4/2)>90 && (a4/2)<180 ) neg = -1;
	if ((a4/2)<0 && (a4/2)>-90 ) neg = -1;
	r3 = neg*rrr/(tan((pi/180)*a4/2));
	dbg gprint("rrr %g a4/2 %g t=%g a2=%g a1=%g r1=%g r2=%g r3=%g \n",rrr,a4/2,tan(a4/2),a2,a1,r1,r2,r3);
	polar_xy(-r3,a1,&ssx,&ssy); ssx += x1; ssy += y1;
	polar_xy(r3,a2,&ex,&ey); ex += x1; ey += y1;
	g_line(ssx,ssy);
	dist = sqrt((ex-ssx) * (ex-ssx) + (ey-ssy)*(ey-ssy));
	polar_xy(r1+ dist/2.5-r3,a1,&bx1,&by1); bx1 += x0; by1 += y0;
	polar_xy(-r2+ -dist/2.5+r3,a2,&bx2,&by2); bx2 += x2; by2 += y2;
	g_bezier(bx1,by1,bx2,by2,ex,ey);
	g_line(x2,y2);
}
/*---------------------------------------------------------------------------*/
d_arc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy)
{
	static int ixr,iyr,icx,icy,a1,a2;
	double ux,uy,z;
	dxy(cx,cy,&icx,&icy);
	rxy(r,r,&ixr,&iyr);
	if (t1>t2) {z = t1; t1 = t2; t2 = z;}
	a1 = t1*64; a2 = t2*64 - a1;
    	XDrawArc(dpy,window1,gc,icx-ixr,icy-iyr,ixr*2,iyr*2,a1,a2);
}
/*---------------------------------------------------------------------------*/
d_narc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy)
{
	static int ixr,iyr,icx,icy,a1,a2;
	double ux,uy,z;
	dxy(cx,cy,&icx,&icy);
	rxy(r,r,&ixr,&iyr);
	if (t1>t2) {z = t1; t1 = t2; t2 = z;}
	a1 = t1*64; a2 = t2*64 - a1;
    	XDrawArc(dpy,window1,gc,icx-ixr,icy-iyr,ixr*2,iyr*2,a1,a2);
}
/*---------------------------------------------------------------------------*/
#else /* arc code from easydev.c */
#define CSTEP (360/6)
df_arcto(dbl x1,dbl y1,dbl x2,dbl y2,dbl rrr)
{
	double x0,y0,r1,a1,r2,a2,r3,a3,a4,r5,sx,sy,ex,ey;
	double bx1,by1,bx2,by2,dist,neg;
	g_get_xy(&x0,&y0);
	xy_polar(x1-x0,y1-y0,&r1,&a1);
	xy_polar(x2-x1,y2-y1,&r2,&a2);
	neg = 1;
	a4 = (180-a2+a1);
	a3 = a2 + (a4/2);
	if ((a4/2)>90 && (a4/2)<180 ) neg = -1;
	if ((a4/2)<0 && (a4/2)>-90 ) neg = -1;
	r3 = neg*rrr/(tan((pi/180)*a4/2));
	polar_xy(-r3,a1,&sx,&sy); sx += x1; sy += y1;
	polar_xy(r3,a2,&ex,&ey); ex += x1; ey += y1;
	g_line(sx,sy);
	dist = sqrt((ex-sx)*(ex-sx) + (ey-sy)*(ey-sy));
	polar_xy(r1+ dist/2.5-r3,a1,&bx1,&by1); bx1 += x0; by1 += y0;
	polar_xy(-r2+ -dist/2.5+r3,a2,&bx2,&by2); bx2 += x2; by2 += y2;
	g_bezier(bx1,by1,bx2,by2,ex,ey);
	g_line(x2,y2);
}
df_arc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy)
{
	/* circle from t1 to t2, lets use 6 bezier's for a circle */
	double stz;
	int nst,i;

	for (;t2<t1;)
	      t2 = t2 + 360;

	nst = floor((t2-t1)/CSTEP)+1;
	stz = (t2-t1) / nst;
	for (i=1;i<=nst;i++)
		xdf_barc(r,t1+stz*(i-1),t1+stz*i,cx,cy);
}
xdf_barc(double r,dbl t1,dbl t2,dbl cx,dbl cy)
{
	double rx1,ry1,rx2,ry2,d,dx1,dy1,dx2,dy2;

	polar_xy(r,t1,&rx1,&ry1);
	polar_xy(r,t2,&rx2,&ry2);
	d = sqrt( (rx2-rx1)*(rx2-rx1) + (ry2-ry1)*(ry2-ry1));
	polar_xy(d/3,t1+90,&dx1,&dy1);
	polar_xy(d/3,t2-90,&dx2,&dy2);
	if (g.inpath) {
		g_line(rx1+cx,ry1+cy);
		g_bezier(rx1+cx+dx1,ry1+cy+dy1
			,rx2+cx+dx2,ry2+cy+dy2,rx2+cx,ry2+cy);
	} else {
		g_move(rx1+cx,ry1+cy);
		g_bezier(rx1+cx+dx1,ry1+cy+dy1
			,rx2+cx+dx2,ry2+cy+dy2,rx2+cx,ry2+cy);
		g_move(cx,cy);
	}
}

d_arcto(dbl x1,dbl y1,dbl x2,dbl y2,dbl rrr)
{
	df_arcto(x1,y1,x2,y2,rrr);
}
/*---------------------------------------------------------------------------*/
d_arc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy)
{        
	df_arc(r,t1,t2,cx,cy);
}
/*---------------------------------------------------------------------------*/
d_narc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy)
{
	/* swap t1 and t2 */
	df_arc(r,t2,t1,cx,cy);
}
/*---------------------------------------------------------------------------*/
#endif /* OLDARC */
/*---------------------------------------------------------------------------*/

d_box_fill(dbl x1, dbl y1, dbl x2, dbl y2)
{
#ifdef OLDARC
	static int ix1,iy1,ix2,iy2;
	static int ii;
	dxy(x1,y1,&ix1,&iy1);
	dxy(x2,y2,&ix2,&iy2);
	if (ix1>ix2) { ii = ix1; ix1 = ix2; ix2 = ii; }
	if (iy1>iy2) { ii = iy1; iy1 = iy2; iy2 = ii; }
    	XFillRectangle(dpy,window1,gcf,ix1,iy1,ix2-ix1,iy2-iy1);
#else
	XPoint point[4];
	int n = 0;

        dxy_short(x1,y1,&point[n].x,&point[n].y); n++;
        dxy_short(x2,y1,&point[n].x,&point[n].y); n++;
        dxy_short(x2,y2,&point[n].x,&point[n].y); n++;
        dxy_short(x1,y2,&point[n].x,&point[n].y);

   	XFillPolygon(dpy,window1,gcf,point,4,Convex,CoordModeOrigin);
#endif
}
d_box_stroke(dbl x1, dbl y1, dbl x2, dbl y2)
{
   	g_move(x1,y1);
        g_line(x2,y1);
        g_line(x2,y2);
        g_line(x1,y2);
        g_line(x1,y1);
}
/*---------------------------------------------------------------------------*/
d_circle_stroke(double zr)
{
#ifdef OLDARC
	static int ixr,iyr;
	int ux,uy;
	rxy(zr,zr,&ixr,&iyr);
	ixr =(fabs(ixr)+fabs(iyr))/2;
	dxy(g.curx,g.cury,&ux,&uy);
    	XDrawArc(dpy,window1,gc,ux-ixr,uy-ixr,ixr*2,ixr*2,0,64*360);
#else
	d_arc(zr,0,360,g.curx,g.cury);
#endif
}
d_circle_fill(double zr)
{
#ifdef OLDARC
	static int ixr,iyr;
	int rr;
	int ux,uy;
	rxy(zr,zr,&ixr,&iyr);
	rr = (fabs(ixr)+fabs(iyr))/2;
	dxy(g.curx,g.cury,&ux,&uy);
    	XFillArc(dpy,window1,gcf,ux-rr,uy-rr,rr*2,rr*2,0,64*360);
#else
	if (!g.inpath){
		g_set_path(true);
		g_newpath();
		g_arc(zr,0,360,g.curx,g.cury);
		g_closepath();
		g_fill();
		g_set_path(false);
	}
	else
		g_arc(zr,0,360,g.curx,g.cury);
#endif
}
/*---------------------------------------------------------------------------*/
d_bezier(dbl x1,dbl y1,dbl x2,dbl y2,dbl x3,dbl y3)
{
	double ax,bx,cx,ay,by,cy,dist;
	double xxx,yyy,i,t,nstep,x0,y0;
	g_get_xy(&x0,&y0);
	dist = fabs(x3-x0) + fabs(y3-y0);
	nstep = 12;
	if (dist<1) nstep = 7;
	if (dist<.5) nstep = 3;
	if (dist<.1) {
		g_line(x3,y3);
		return;
	}
	cx = (x1-x0)*3;
	bx = (x2-x1)*3-cx;
	ax = x3-x0-cx-bx;
	cy = (y1-y0)*3;
	by = (y2-y1)*3-cy;
	ay = y3-y0-cy-by;
	for (i=0;i<=nstep;i++) {
		t = i/nstep;
		xxx = ax*pow(t,3.0) + bx*t*t + cx*t + x0;
		yyy = ay*pow(t,3.0) + by*t*t + cy*t + y0;
		g_line(xxx,yyy);
	}
}
/*---------------------------------------------------------------------------*/
d_set_color(int32 f)			/* colors slightly changed a.r. */
{
	int i;
	colortyp  cc;
	cc.l = f;
	i = 1;
	if (cc.b[B_R]>=10 && cc.b[B_G]>=10 && cc.b[B_B]>=10) 	i = 9;
	if (cc.b[B_R]>60  && cc.b[B_G]>60  && cc.b[B_B]>60)  	i = 8;
	if (cc.b[B_R]>100) 					i = 2;
	if (cc.b[B_B]>100) 					i = 4;
	if (cc.b[B_G]>100) 					i = 3;
	if (cc.b[B_R]>100 && cc.b[B_G]>100) 			i = 5;
	if (cc.b[B_G]>100 && cc.b[B_B]>100) 			i = 7;
	if (cc.b[B_R]>30  && cc.b[B_B]>100) 			i = 6;
	if (cc.b[B_R]>100 && cc.b[B_G]>100 && cc.b[B_B]>100) 	i = 8;
	if (cc.b[B_R]<10  && cc.b[B_G]<10  && cc.b[B_B]<10) 	i = 1; 
	if (cc.b[B_R]>250 && cc.b[B_G]>250 && cc.b[B_B]>250) 	i = 0;
        
	setcolor(i);
}
d_set_fill(int32 f)			/* colors slightly changed a.r. */
{
	int i, j;
	colortyp  cc;
	cc.l = f;
	i = 1;
   	j = 0;
        if (cc.b[B_F] == 1)     /* colours */
           {
           	if (cc.b[B_R]>=10 && cc.b[B_G]>=10 && cc.b[B_B]>=10) 	i = 9;
                if (cc.b[B_R]>60  && cc.b[B_G]>60  && cc.b[B_B]> 60)  	i = 8;
                if (cc.b[B_R]>100) 					i = 2;
                if (cc.b[B_B]>100) 					i = 4;
                if (cc.b[B_G]>100) 					i = 3;
                if (cc.b[B_R]>100 && cc.b[B_G]>100) 			i = 5;
                if (cc.b[B_G]>100 && cc.b[B_B]>100) 			i = 7;
                if (cc.b[B_R]>30  && cc.b[B_B]>100) 			i = 6;
                if (cc.b[B_R]>100 && cc.b[B_G]>100 && cc.b[B_B]>100) 	i = 8;
                if (cc.b[B_R]<10  && cc.b[B_G]<10  && cc.b[B_B]< 10) 	i = 1; 
                if (cc.b[B_R]>250 && cc.b[B_G]>250 && cc.b[B_B]>250) 	i = 0;
                XSetFillStyle(dpy, gcf, FillSolid);
                d_fillcolor = i;
                setfillcolor(i);
           }
        if (cc.b[B_F] == 2)     /* grids and shades */
           {
                if (cc.b[B_R]==0x00 && cc.b[B_G]==0x00 && cc.b[B_B]==0x20) j=0; /* SHADE  */
                if (cc.b[B_R]==0x04 && cc.b[B_G]==0x00 && cc.b[B_B]==0x0C) j=1; /* SHADE1 */
                if (cc.b[B_R]==0x00 && cc.b[B_G]==0x00 && cc.b[B_B]==0x10) j=2; /* SHADE2 */
                if (cc.b[B_R]==0x05 && cc.b[B_G]==0x00 && cc.b[B_B]==0x20) j=3; /* SHADE3 */
                if (cc.b[B_R]==0x10 && cc.b[B_G]==0x00 && cc.b[B_B]==0x40) j=4; /* SHADE4 */
                if (cc.b[B_R]==0x20 && cc.b[B_G]==0x00 && cc.b[B_B]==0x60) j=5; /* SHADE5 */
                if (cc.b[B_R]==0x00 && cc.b[B_G]==0x20 && cc.b[B_B]==0x20) j=6; /* GRID   */
                if (cc.b[B_R]==0x04 && cc.b[B_G]==0x0f && cc.b[B_B]==0x0f) j=7; /* GRID1  */
                if (cc.b[B_R]==0x00 && cc.b[B_G]==0x10 && cc.b[B_B]==0x10) j=8; /* GRID2  */
                if (cc.b[B_R]==0x05 && cc.b[B_G]==0x20 && cc.b[B_B]==0x20) j=9; /* GRID3  */
                if (cc.b[B_R]==0x10 && cc.b[B_G]==0x40 && cc.b[B_B]==0x40) j=10;/* GRID4  */
                if (cc.b[B_R]==0x20 && cc.b[B_G]==0x60 && cc.b[B_B]==0x60) j=11;/* GRID5  */
                setfillcolor(1); /* black */
        	setfillstyle(j);
           }
        else
           {
              	XSetFillStyle(dpy, gcf, FillSolid);
                setfillcolor(d_fillcolor);
           }
}
/*---------------------------------------------------------------------------*/
d_beginclip()
{
}
d_endclip()
{
}
struct char_data {float wx,wy,x1,y1,x2,y2; };
int font_get_chardata(struct char_data **cd, int ff, int cc);
/*---------------------------------------------------------------------------*/
int safnt;
int simple_char(int cc);
d_char(int font, int cc)
{
	static struct char_data cd;
	static int ix1,ix2,iy1,iy2;
	static int ux,uy;
	char ss[2];

	in_font = true;
	ss[0] = cc;
	ss[1] = 0;
	if (safnt==0) safnt = pass_font("PLSR");
	if (font_get_encoding(font)>2) {
		my_char(font,cc);
		in_font = false;
		return;
	}
	my_char(safnt,cc);
	in_font = false;
}


int wait_expose()
{
	/* Wait till he presses key or clicks mouse */
	XEvent ereturn;
	int32 emask;

/*	for (;;) {
		XNextEvent(dpy,&ereturn);
		wprintf("Event %d  %d %d %d\n",ereturn.type,Expose,ButtonPress,
			VisibilityNotify);
		scr_refresh();
	}
*/
/*	 XSync(dpy,True);	*/
    	emask = ExposureMask | ButtonPressMask | KeyPressMask;
	XWindowEvent(dpy, window1, emask, &ereturn);
}

int set_expose()
{
   XEvent ereturn;
   int32 emask;

   emask = ExposureMask | ButtonPressMask | KeyPressMask
			| VisibilityChangeMask;

/* #define X11R5 true for X11R5 and R6 */
#define X11R5 true
#ifdef X11R5
	XSelectInput(dpy, window1, emask);
#else
	XSelectInput(dpy, window1, emask, &ereturn);
#endif
}


/*-------------------------------------------------------------------------*/
/*			path routines for x windows */
#define PATH_LENGTH 500
struct Pnt {int type,x,y;} ;
static struct Pnt pnts[PATH_LENGTH];
static int npnts;
enum {P_MOVE,P_LINE,P_BEZIER};
static int startx,starty;
void path_move(int x, int y)
{
	startx = x; starty = y;
	pnts[npnts].type = P_MOVE;
	pnts[npnts].x = x;
	pnts[npnts++].y = y;
}
void path_line(int x, int y)
{
	pnts[npnts].type = P_LINE;
	pnts[npnts].x = x;
	pnts[npnts++].y = y;
}
void path_close(void)
{
	pnts[npnts].type = P_LINE;
	pnts[npnts].x = startx;
	pnts[npnts++].y = starty;
}
void path_fill(void)
{
	XPoint pts[PATH_LENGTH];
	int i,npts;

	for (i=0; i<npnts; i++) {
		if (pnts[i].type==P_LINE) {
			npts = 0;
			pts[npts].x = pnts[i].x;
			pts[npts++].y = pnts[i++].y;
			for (;pnts[i].type==P_LINE && i<npnts;i++) {
				pts[npts].x = pnts[i].x;
				pts[npts++].y = pnts[i].y;
			}
		   	XFillPolygon(dpy,window1,gcf,pts,npts,Complex, CoordModeOrigin);
		}
	}
}
void path_newpath(void)
{
	npnts = 0;
}
void path_stroke(void)
{
	for (i=1; i<npnts; i++) {
		if (pnts[i].type==P_LINE) {
		    	XDrawLine(dpy,window1,gc,
				pnts[i-1].x,pnts[i-1].y,
				pnts[i].x,pnts[i].y);
		}
	}
}

