#include <uisusrdef.h>
#include <descrip.h>
#include <stdio.h>
/*--------------------------------------------------------------*/
/*	Regis Driver 1.0 (TURBO  C) , for GLE V3.0		*/
/*--------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
#include "all.h"
#include <math.h>
#include "core.h"
#include "mygraph.h"
#include "mydev.h"
int ingraphmode;
extern struct gmodel g;
extern int gle_speed;
extern int gle_nspeed;
/*---------------------------------------------------------------------------*/
#define pi 3.141592653
#define true (!false)
#define BLACKANDWHITE 1
#define ESC 27
#define false 0
#define dbg if ((gle_debug & 64)>0)
#define stop if ((gle_debug & 128)>0) return
extern int gle_debug;
int incap=true;
int getch(void);
/*---------------------------------------------------------------------------*/
/* The global variables for the PC screen driver */
/*-----------------------------------------------*/

float savexsize,saveysize;
int l,j;
float ix,iy;
double f;
float oldx,oldy;
int attrib=1;
int attribf=2;
int32 vcm_id,map_size,vd_id,i,wd_id;
float xsizecm, ysizecm, resolx, resoly, display_x, display_y;
float zval;
float windowx,windowy;

#define sx(v) ( (v) * d_xscale)
#define sy(v) ( (v) * d_yscale)
#define rx(v) ( (v) * d_xscale)
#define ry(v) ( (v) * d_yscale)

double d_scale, d_xscale, d_yscale;
int d_graphmode;
int d_fillstyle=1,d_fillcolor;
int d_lstyle,d_lwidth;
int d_maxy;

d_devcmd(char *s)
{}
dxy(double x, double y, float *dx, float *dy)
{
	static double fx,fy;
	g_dev(x,y,&fx,&fy);
	*dx = sx(fx);
	*dy = sy(fy);
}
rxy(double x, double y, float *dx, float *dy)
{
	static double fx,fy,zx,zy;
	g_dev(x,y,&fx,&fy);
	g_dev(0.0,0.0,&zx,&zy);
	*dx = ( (fx-zx) * d_xscale);
	*dy = ( (fy-zy) * d_yscale);
}
/*---------------------------------------------------------------------------*/
d_dfont(char *c)
{
	/* only used for the DFONT driver which builds fonts */
}
/*---------------------------------------------------------------------------*/
static char lastline[80];
d_message(char *s)
{
	static int single_step;
	int oldcolor,oldx,oldy;
		w_message(s);
}
/*---------------------------------------------------------------------------*/
d_source(char *s)
{
	s=s;
}
/*---------------------------------------------------------------------------*/
d_get_type(char *t)
{
	strcpy(t,"INTERACTIVE, UIS, VAX");
	gle_speed = 0; /* set to slow speed by default for UIS driver. */
}
/*---------------------------------------------------------------------------*/
d_set_path(int onoff)
{}
/*---------------------------------------------------------------------------*/
d_newpath()
{
}
/*---------------------------------------------------------------------------*/
d_open(double width, double height)
{
   	static $DESCRIPTOR(workstation,"sys$workstation");
   	static $DESCRIPTOR(fillfont,"uis$fill_patterns");

	gle_nspeed = 2; /* text mode = slow and fast */
 	uis$get_display_size(&workstation, &xsizecm, &ysizecm, &resolx, &resoly);

	xsizecm = 20;
	ysizecm = 16;
	map_size = 8;
	/* Get largest rectangle we can fit on the screen */
	d_scale = xsizecm / width;
	f = ysizecm / height;
	if (f<d_scale) d_scale = f;

	d_xscale = d_scale ;
	d_yscale = d_scale ;
	g.userwidth = width;
	g.userheight = height;

	xsizecm = width*d_scale;
	ysizecm = height*d_scale;

	if (vd_id==NULL  || xsizecm != savexsize || ysizecm != saveysize) {
		if (vd_id!=NULL) {
			uis$delete_window(&wd_id);
			uis$delete_display(&vd_id);
			uis$delete_color_map(&vcm_id);
		}
      		vcm_id = uis$create_color_map(&map_size,0,0);
      		vd_id = uis$create_display(&zval,&zval,&xsizecm,&ysizecm
                             ,&xsizecm,&ysizecm,&vcm_id);
      		wd_id = uis$create_window(&vd_id,&workstation);
		set_uis_colors();
	}
	saveysize = ysizecm;
	savexsize = xsizecm;
	uis$set_writing_mode(&vd_id,&0,&attrib,&UIS$C_MODE_REPL);
	uis$set_writing_mode(&vd_id,&0,&attribf,&UIS$C_MODE_REPL);
	uis$set_writing_index(&vd_id,&attrib,&attrib,&1);
	uis$set_writing_index(&vd_id,&attribf,&attribf,&1);
	uis$set_font(&vd_id,&attribf,&attribf,&fillfont);
	uis$set_fill_pattern(&vd_id,&attribf,&attribf,&PATT$C_FOREGROUND);
}
/*---------------------------------------------------------------------------*/
#define getcolor(cname) uis$get_ws_color(&vd_id,&cname,&r,&g,&b); \
			uis$set_color(&vd_id,&ci,&r,&g,&b); ci++;
set_uis_colors()
{
	int ci=0;
	float r,g,b;
	getcolor(UIS$C_WS_WHITE);
	getcolor(UIS$C_WS_BLACK);
	getcolor(UIS$C_WS_RED);
	getcolor(UIS$C_WS_GREEN);
	getcolor(UIS$C_WS_BLUE);
	getcolor(UIS$C_WS_CYAN);
	getcolor(UIS$C_WS_YELLOW);
	getcolor(UIS$C_WS_MAGENTA);
}
/*---------------------------------------------------------------------------*/
d_tidyup()
{
}
d_close()
{

	g_flush();
	textmode();
	fner("Picture completed, press RETURN to continue                    (Press any key)");
 	text_inkey();
	uis$push_viewport(&wd_id);
}
/*---------------------------------------------------------------------------*/
d_set_line_cap(int i)
{
	i++;
}
/*---------------------------------------------------------------------------*/
d_set_line_join(int i)
{
	i++;
}
/*---------------------------------------------------------------------------*/
d_set_line_miterlimit(double d)
{
	i++;
}
/*---------------------------------------------------------------------------*/
d_set_line_width(double w)
{
	float wf;
	wf = w;
	uis$set_line_width(&vd_id,&attrib,&attrib,&wf,&UIS$C_WIDTH_WORLD);
}
/*---------------------------------------------------------------------------*/
d_set_line_styled(double dd)
{}
d_set_line_style(char *s)
{
	uint32 bitimg;
	d_lstyle = 2;
	if (strcmp(s,"")==0) d_lstyle = 1;
	if (strcmp(s,"0")==0) d_lstyle = 1;
	if (strcmp(s,"1")==0) d_lstyle = 1;
	if (d_lstyle!=1) bitimg = 0XF00FF00F;
	else bitimg = 0XFFFFFFFF;
	uis$set_line_style(&vd_id,&attrib,&attrib,&bitimg);
}
/*---------------------------------------------------------------------------*/
d_fill()
{
}
/*---------------------------------------------------------------------------*/
d_fill_ary(int nwk,double (*wkx)[],double (*wky)[])
{
	int i;
/*	fprintf(psfile,"%g %g moveto \n",(*wkx)[0],(*wky)[0]);
	for (i=1;i<nwk;i++)
		fprintf(psfile,"%g %g l \n",(*wkx)[i],(*wky)[i]);
*/
}
d_line_ary(int nwk,double (*wkx)[],double (*wky)[])
{
	int i;
/*
	dxy( (*wkx)[0], (*wky)[0], &ix, &iy);
	moveto(ix,iy);
	for (i=1;i<nwk;i++) {
		dxy( (*wkx)[i], (*wky)[i], &ix, &iy);
		lineto(ix,iy);
	}
*/
}
/*---------------------------------------------------------------------------*/
d_stroke()
{
}
/*---------------------------------------------------------------------------*/
d_clip()
{
}
/*---------------------------------------------------------------------------*/
d_set_matrix(double newmat[3][3])
{
}
/*---------------------------------------------------------------------------*/
d_move(double zx,double zy)
{
}
/*---------------------------------------------------------------------------*/
d_reverse() 	/* reverse the order of stuff in the current path */
{
}
/*---------------------------------------------------------------------------*/
d_closepath()
{
	g_line(g.closex,g.closey);
}
/*---------------------------------------------------------------------------*/
d_line(double zx,double zy)
{
	static float ux,uy;
	dxy(g.curx,g.cury,&oldx,&oldy);
	dxy(zx,zy,&ux,&uy);
	uis$line(&vd_id,&attrib,&oldx,&oldy,&ux,&uy);
}
/*---------------------------------------------------------------------------*/
d_clear()
{
	int flag,i;
	flag = (UIS$M_DL_ENHANCE_LIST | UIS$M_DL_MODIFY_LIST);
	uis$erase(&vd_id);
	uis$disable_display_list(&vd_id,&flag);
	i = 1;
	uis$set_writing_index(&vd_id,&attrib,&attrib,&i);
	uis$pop_viewport(&wd_id);
}
/*---------------------------------------------------------------------------*/
d_flush()
{
}
/*---------------------------------------------------------------------------*/
d_arcto(dbl x1,dbl y1,dbl x2,dbl y2,dbl rrr)
{
}
/*---------------------------------------------------------------------------*/
d_arc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy)
{
	static float ixr,iyr,icx,icy,ixs,iys;
	double ux,uy,z,xs,ys;
	float ta1,ta2;


	if (t1>t2) {z = t1; t1 = t2; t2 = z;}
	ta1 = t1;
	ta2 = t2;
	polar_xy(r,t1,&xs,&ys);
	rxy(xs,ys,&ixs,&iys);

	dxy(cx,cy,&icx,&icy);
	rxy(r,r,&ixr,&iyr);
	uis$circle(&vd_id,&attrib,&icx,&icy,&ixr,&ta1,&ta2);
	g.xinline = false;
}
/*---------------------------------------------------------------------------*/
d_narc(dbl r,dbl t1,dbl t2,dbl cx,dbl cy)
{
	static float ixr,iyr,icx,icy,ixs,iys;
	double ux,uy,z,xs,ys;
	float ta1,ta2;


	if (t1>t2) {z = t1; t1 = t2; t2 = z;}
	ta1 = t1;
	ta2 = t2;
	polar_xy(r,t1,&xs,&ys);
	rxy(xs,ys,&ixs,&iys);

	dxy(cx,cy,&icx,&icy);
	rxy(r,r,&ixr,&iyr);
	uis$circle(&vd_id,&attrib,&icx,&icy,&ixr,&ta1,&ta2);
	g.xinline = false;
}
/*---------------------------------------------------------------------------*/
d_box_fill(dbl x1, dbl y1, dbl x2, dbl y2)
{
	static float ix1,iy1,ix2,iy2;
	static float ii;
	dxy(x1,y1,&ix1,&iy1);
	dxy(x2,y2,&ix2,&iy2);
	uis$plot(&vd_id,&attribf, &ix1,&iy1, &ix2,&iy1, &ix2,&iy2, &ix1,&iy2
		, &ix1,&iy1);
	g.xinline = false;
}
d_box_stroke(dbl x1, dbl y1, dbl x2, dbl y2)
{
	static float ix1,iy1,ix2,iy2,ix3,iy3,ix4,iy4;
	static float ii;
	dxy(x1,y1,&ix1,&iy1);
	dxy(x2,y2,&ix2,&iy2);
	uis$plot(&vd_id,&attrib, &ix1,&iy1, &ix2,&iy1, &ix2,&iy2, &ix1,&iy2
		, &ix1,&iy1);
	g.xinline = false;
}
/*---------------------------------------------------------------------------*/
d_circle_stroke(double zr)
{
	static float ixr,iyr;
	float ux,uy;
	rxy(zr,zr,&ixr,&iyr);
	dxy(g.curx,g.cury,&ux,&uy);
	uis$circle(&vd_id,&attrib,&ux,&uy,&ixr);
	g.xinline = false;
}
d_circle_fill(double zr)
{
	static float ixr,iyr;
	float ux,uy;
	dxy(g.curx,g.cury,&ux,&uy);
	rxy(zr,zr,&ixr,&iyr);
	uis$circle(&vd_id,&attribf,&ux,&uy,&ixr);
	g.xinline = false;
}
/*---------------------------------------------------------------------------*/
d_bezier(dbl x1,dbl y1,dbl x2,dbl y2,dbl x3,dbl y3)
{
	double ax,bx,cx,ay,by,cy,dist;
	double xxx,yyy,i,t,nstep,x0,y0;
	g_get_xy(&x0,&y0);
	dist = fabs(x3-x0) + fabs(y3-y0);
	nstep = 10;
	if (dist>3) nstep = 20;
	if (dist<.5) nstep = 5;
	if (dist<.3) nstep = 3;
 	if (dist<.1) {
		g_line(x3,y3);
		return;
	}
	cx = (x1-x0)*3;
	bx = (x2-x1)*3-cx;
	ax = x3-x0-cx-bx;
	cy = (y1-y0)*3;
	by = (y2-y1)*3-cy;
	ay = y3-y0-cy-by;
	for (i=0;i<=nstep;i++) {
		t = i/nstep;
		xxx = ax*pow(t,3.0) + bx*t*t + cx*t + x0;
		yyy = ay*pow(t,3.0) + by*t*t + cy*t + y0;
		g_line(xxx,yyy);
	}
}
/*---------------------------------------------------------------------------*/
d_set_color(int32 f)
{
	int i;
	colortyp  cc;
	cc.l = f;
	i = 1;
	if (cc.b[B_R]>1 && cc.b[B_G]>1 && cc.b[B_B]>1) i = 4;
	if (cc.b[B_R]>60 && cc.b[B_G]>60 && cc.b[B_B]>60) i = 6;
	if (cc.b[B_R]>100) i = 2;
	if (cc.b[B_B]>100) i = 4;
	if (cc.b[B_G]>100) i = 3;
	if (cc.b[B_R]>100 && cc.b[B_G]>100) i = 5;
	if (cc.b[B_G]>100 && cc.b[B_B]>100) i = 7;
	if (cc.b[B_R]>250 && cc.b[B_G]>250 && cc.b[B_B]>250) i = 0;
	uis$set_writing_index(&vd_id,&attrib,&attrib,&i);
}
d_set_fill(int32 f)
{
	int i;
	int p;
	colortyp  cc;
	cc.l = f;
	i = 1;
	p = PATT$C_FOREGROUND;
	if (cc.b[B_R]>1 && cc.b[B_G]>1 && cc.b[B_B]>1) i = 4;
	if (cc.b[B_R]>30 && cc.b[B_G]>30 && cc.b[B_B]>30)
		{p = PATT$C_GREY14_16;  i = 1;}
	if (cc.b[B_R]>70 && cc.b[B_G]>70 && cc.b[B_B]>70)
		{p = PATT$C_GREY10_16;  i = 1;}
	if (cc.b[B_R]>100) i = 2;
	if (cc.b[B_B]>100) i = 4;
	if (cc.b[B_G]>100) i = 3;
	if (cc.b[B_R]>100 && cc.b[B_G]>100) i = 5;
	if (cc.b[B_G]>100 && cc.b[B_B]>100) i = 7;
	if (cc.b[B_R]>100 && cc.b[B_G]>100 && cc.b[B_B]>100)
		{p = PATT$C_GREY4_16;  i = 1;}
	if (cc.b[B_R]>160 && cc.b[B_G]>160 && cc.b[B_B]>160)
		{p = PATT$C_GREY1_16;  i = 1;}
	if (cc.b[B_R]>250 && cc.b[B_G]>250 && cc.b[B_B]>250)
		{p = PATT$C_FOREGROUND; i = 0;}
	uis$set_writing_index(&vd_id,&attribf,&attribf,&i);
	uis$set_fill_pattern(&vd_id,&attribf,&attribf,&p);
}
/*---------------------------------------------------------------------------*/
d_beginclip()
{
}
d_endclip()
{
}
struct char_data {float wx,wy,x1,y1,x2,y2; };
int font_get_chardata(struct char_data **cd, int ff, int cc);
/*---------------------------------------------------------------------------*/
d_char(int font, int cc)
{
	static struct char_data cd;
	static float ix,iy,ix1,ix2,iy1,iy2,fz,fzx;
	static float ux,uy;
	static int safnt;
	char ss[2];

	ss[0] = cc;
	ss[1] = 0;

	if (gle_speed==1 && isalnum(cc)) {
		fast_char(font,cc);
		return;
	}
	if (safnt==0) safnt = pass_font("PLSR");
	if (font_get_encoding(font)>2) {
		my_char(font,cc);
		return;
	}
	my_char(safnt,cc);
}

/*---------------------------------------------------------------------------*/
fast_char(int font, int cc)
{
	static struct char_data cd;
	static float ix,iy,ix1,ix2,iy1,iy2,fz,fzx;
	static int ux,uy;
   	static $DESCRIPTOR(sdesc,"a");
	char ss[2];

	sdesc.dsc$a_pointer = ss;
	ss[0] = cc;
	ss[1] = 0;
	stop;

	if (font_get_encoding(font)>2) {
		my_char(font,cc);
		return;
	}
	if (g.fontsz==0) g.fontsz = 1;
	dxy(g.curx, g.cury , &ix1, &iy1);
	rxy(g.fontsz * .5,g.fontsz * 1.0,&fzx,&fz);
	uis$set_char_size(&vd_id,&attrib,&attrib,&sdesc,&fzx,&fz);
	uis$set_position(&vd_id,&ix1,&iy1);
	uis$text(&vd_id,&attrib,&sdesc);
}
graphmode()
{
	ingraphmode = true;
}
textmode()
{
	ingraphmode = false;
}
getmaxx()
{
	return 799;
}
getmaxy()
{
	return 479;
}





