/*
 *
 * Fudgit configuration file
 * Edit the following before compiling.
 *
 * The HELPFILE variable should be defined by the makefile.
 *
 * Martin-D. Lacasse
 * May 1992
 *
 */

/* where to find the help file: Now defined from the Makefile */
/* #define HELPFILE	 "/usr/local/lib/fudgit.help"  */
/* the default pager if not defined in env	*/
#define DEFPAGER	 "more"
/* default shell if not defined in env */
#define DEFSHELL	  "/bin/csh"
/* the default plotting program */
#define PLOTTING	 "/usr/local/bin/gnuplot"
/* the default number printing format  */
#define FORMAT	   "% 10.8e"
/* the default variable number printing format  */
#define VFORMAT	   "%.3g"
/* the default fit iteration number  */
#define ITER		 10
/* The default history name */
#define HISTORY	  ".hist_fudgit"
/* The maximum number of memory entries */
#define HISTNUM	  52

/* Be sure you know what you are doing before editing the following */
#define MAXMACRO	 2048	  /* max size of a macro >= LINESIZE */
#define MAXARG	   16		/* max number of arguments for a macro */
#define MAXPARG	  16		/* max number of arguments for plotting prg */
#define MAXDARG	  16		/* max number of arguments for _dumplot */
							   /* do not increase MAXLEVEL above supported
								 number of simultaneous fopen files. */
#define MAXLEVEL	 32		/* max nesting of macros and I/O */
#define MAXIF		32		/* max nesting of if's */
#define LINESIZE	 1024	  /* max size of input line */
#define MAXTOKEN	 256	   /* max number of columns-tokens */
#define TOKENSIZE	128	   /* max size of a token  */
#define MAXPTS	   4000	  /* default number of data points  */
#define MAXVAR	   32		/* max number for show/save/append variable */
#define MAXVARNAME   32		/* max size for variable names  */
#define MAXFUNCARG   32		/* max number of function/proc. arguments  */
#define MAXERR	   10		/* error tolerance while reading datafiles  */
#define MATHMAXARG   35		/* max number of arguments for math
								   external functions and procedures
								   edit code.c:extcall() if changed */
#define MATHMAXFUNC  10		/* max number of functions for external
								  loading from one module */
#define NL		    (0)
#define RESET		(0)
#define ERRR		(-1)
#define VERRR		(-2)
#define REPORT	    (-3)
#define PROMPT_FM	"fudgit> "
#define PROMPT_CM	"cmode> "
#define PROMPT_PM	"pmode> "
#define MAXPROMPT	32
#define PATH_MAXIM   1024	  /* max path length supported  */
#define YES 1
#define NO  0
/* If states */
#define FALSE_IF  0
#define TRUE_IF   1
#define DONE_IF   2
#define DUMMY_IF  3
#define FORCED_IF 4
#define NFORCE_IF 5
/* expansion styles */
#define NOTHING   00
#define QUOTES	01
#define PARENTH   02
#define EXPANSION 04
/* Mode styles */
#define FMODE 0
#define CMODE 1
#define PMODE 2
/* Math error check modes */
#define INF_CHK		001
#define NAN_CHK	 002
#define EDOM_CHK	004
#define ERANGE_CHK  010
/* Debugging values */
#define DEBUG_EXP	 001
#define DEBUG_RAW	 002
#define DEBUG_READ	004
#define DEBUG_MATH	010
#define DEBUG_PARSER  020
#define DEBUG_IF	  040
/* The filename extension. If defined, FUDGIT will try to open files
 * ending by ".EXTENSION" first by appending .EXTENSION to filename
 * not ending by this. If not found, it will try with the original
 * name.
 * Ideally, this exception is left for .fudgitrc.
 */
/* #define EXTENSION  ".ft"  */
/* The following are required when defining argument prototypes of
 * loaded routines.
 */
#define PROTO_END		(00)
#define PROTO_VAL		(01)
#define PROTO_VEC		(02)
#define PROTO_PAR		(03)
#define PROTO_MAT		(04)
#define PROTO_STR		(05)

