# $Date: 1994/06/06 09:46:03 $ $Author: linus $ $Revision: 1.1 $ #

# andi, 07/03/94 #

#++
tvnew  - Allocate a new temporary variable

tvnew( _attr_  [, var_type] )

_attr_     - Attribute (destination)
var_type   - Attribute (source)
++#


####################################################################################################
# NAME:        M2C_new_tv                                                                          #
# PARAMETER:   _attr_ = aktuelle Attributtabelle des Parsers                                       #
#              args(2)= Typ : DOM_STRING (optional)                                                #
# FUNKTION:    Liefert den String einer neuen temporaeren C-Kode-Variable.  Der Typ der Variable   #
#              kann (optional) als zweites Argument angegeben werden.  Standardmaessig wird  (*)   #
#              (s.u.) angenommen. Der Variablenindex wird im Attribut ["@FLOW"]["?N"] verwaltet;   #
#              der hierbei aufgetretene Maximalwert in ["@FLOW"]["?MAX"]. Letzterer bestimmt die   #
#              Groesse des Vektors 'MF?[]' in der aktuell erzeugten Modulfunktion.                 #
#                                                                                                  #
#              Folgende Typen werden zur Zeit unterstuetzt:                                        #
#                                                                                                  #
#              "TVC"    : temp. S_Pointer                                                          #
#              "TVPC"   : temp. S_Pointer                                                          #
#                                                                                                  #
#              ACHTUNG: Die Funktion aendert als Seiteneffekt folgende Eintraege der gegebenen     #
#                       Attributtabelle:                                                           #
#                                         _attr_["@FLOW"]["?N"]    (+1)                            #
#                                         _attr_["@FLOW"]["?MAX"]  (ggf.+1)                        #
####################################################################################################
mmc::tvnew:= proc( _attr_ # , var_type # )
option	hold;
local	id_name_m, id_name_c, tv_name, tv_index;
begin
	### Welcher Variablentyp wird angefordert  #################################################
	
	if  ( args(0) = 1         ) then id_name_m:= "TVC";   id_name_c:= "tvc";
	elif( args(2) = "TVC"     ) then id_name_m:= "TVC";   id_name_c:= "tvc";
	elif( args(2) = "TVPC"    ) then id_name_m:= "TVPC";  id_name_c:= "tvpc";
	else                        error( "fatal -- Bad type of temp. variable: \"".args(2)."\"" ); 
	end_if;
	
	### Zaehler erhoehen und Variablenname liefern #############################################

	tv_index:= level( _attr_["@FLOW"][id_name_m."N"], 99 );
	tv_name := "MF".id_name_c."[".tv_index."]";	
	tv_index:= evalassign(_attr_["@FLOW"][id_name_m."N"], tv_index+1, 1);

	if( tv_index > level(_attr_["@FLOW"][id_name_m."MAX"],99) ) then 
		evalassign( _attr_["@FLOW"][id_name_m."MAX"], tv_index, 1 );
	end_if;
	
	return( tv_name );
end_proc:

# end of file #
