# $Date: 1994/11/07 10:54:09 $ $Author: andi $ $Revision: 1.3 $ #

# andi, 07/11/94 #

#++
m2c  - "MuPAD->C"-Pass of MuPAD-Modul-Compiler

m2c( pass2_ )

pass2_ - FALSE, if this is the fist pass of 'm2c'

At first, all code-output-files are opened and initialized. Then every 
object in the global list 'mmc::objects' will be compiled.  After that
the code-output-files will be concluded and closed.
++#

mmc::m2c:= proc( pass2_ )
local	i_, obj_, do_pass2_;
begin
	if( domtype(mmc::option) <> DOM_SET ) then
		error( "'mmc::option' must be DOM_SET" );
	end_if;

	#++ Initialize all code-output-files ++++++++++++++++++++++++++++++++++#
	
		#++ ".log"  - log-file for debugging ++++++++++++++++++++++++++#

	if( mmc::loglevel > 0 ) then
		mmc::l := mmc::copen( mmc::modul.".log" );
		mmc::crl( mmc::l, "", " PROTOKOLL: \"mist\" ", "" );
		mmc::cl ( mmc::l, "" );
	end_if;
	
		#++ ".c"   - C-code-file: functions +++++++++++++++++++++++++++#

	mmc::c := mmc::copen( mmc::modul.".c" );
	
	mmc::crl( mmc::c, "" );
	mmc::cl ( mmc::c, 
	"/***",
	" *** FILE  : ".mmc::modul.".c",
	" *** AUTHOR: ".mmc::version."",
	" *** INFO  : This files was created by the MuPAD-compiler. It",
	" ***         contains C-code, which can be used to generate a",
	" ***         MuPAD modul. Also refer to the file '<FILE>.mdg'",
	" ***         and '<FILE>.h'.                                 ",
	" ***/ "
	);
	mmc::crl( mmc::c, "" );
	mmc::cl ( mmc::c, 
	"",
	"#include \"MMT_tool.c\"",
	"#include \"".mmc::modul.".h\"",
	"",
	"/*MERGE+*/",
	""
	);
		
		#++ ".h"   - C-code-file: definements +++++++++++++++++++++++++#

	mmc::h := mmc::copen( mmc::modul.".h" );
	
	mmc::crl( mmc::h, "" );
	mmc::cl ( mmc::h, 
	"/*** ",
	" *** FILE  : ".mmc::modul.".h",
	" *** AUTHOR: ".mmc::version."",
	" *** INFO  : This files was created by the MuPAD-compiler. It",
	" ***         contains C-code, which can be used to generate a",
	" ***         MuPAD modul. Also refer to the file '<FILE>.mdg'",
	" ***         and '<FILE>.c'.                                 ",
	" ***/ "
	);
	mmc::crl( mmc::h, "" );
	mmc::cl ( mmc::h, "" );
	mmc::crl( mmc::h, "Static definements" );
	mmc::cl ( mmc::h, 
	"",
	"#define MF_GEN_PV        1L  /* generic-index: formal parameter */",
	"#define MF_GEN_LV        2L  /* generic-index: local  variables */",
	"",
	"#define MF_STORAGE_TYPE  MMMCglobal",
	"",
	"#define MF_TRUE          1L",
	"#define MF_FALSE         0L",
	"",
	""
	);
	mmc::crl( mmc::h, "Private definements of each modul function" );
	mmc::cl ( mmc::h, 
	"/*MERGE+*/", 
	"" 
	);
	
		#++ ".mdg" - MuPAD-code-file: generics ++++++++++++++++++++++++#

	mmc::g := mmc::copen( mmc::modul.".mdg" );
	
	mmc::cl( mmc::g,
	"#+",
	"++ FILE  : ".mmc::modul.".mdg",
	"++ AUTHOR: ".mmc::version,
	"++ INFO  : This files was created by the MuPAD-compiler. It",
	"++         contains  'generic' -elements of the MuPAD modul",
	"++         <FILE> and will be loaded at runtime. Also refer",
	"++         to the files '<FILE>.c' and '<FILE>.h'.",
	"+#",
	"",
	"#++ DO NOT CHANGE THE FOLLOWING LINES !!! ++++++++++++++++#",
	"",
	"MMC_HOLD_OBJ:= eval:",
	"",
	"table( "
	);
	mmc::cpush( mmc::g );
	mmc::cl( mmc::g, "#MERGE+#", "" );

	#++ Call of m2c-parser for each object ++++++++++++++++++++++++++++++++#
		
	do_pass2_:= FALSE;               #++ Assumption: one pass is enough ++#
	
	if( not pass2_ ) then mmc::vobjects:= table(); #++ del. parser-info ++#
	end_if;
	
	MC_HOLD_OBJ:= NIL:                              #++ Dummy for 'hold' ++#
	
	i_:= 1;
	while( i_ <= mmc::nobjects ) do
		mmc::object := mmc::objects[i_];
		#++ Die folgende Evaluierung muesste eigentlich im Kontext   ++#
		#++ der interaktiven Ebene stattfinden.                      ++#
		obj_   := level( eval(text2expr(mmc::object)), 99 );
		mmc::stmt   := 0;   
		mmc::depth  := 0;
		
		#++ Choose and call parser-entry for current object +++++++++++#
		
		if( domtype(obj_) = DOM_PROC ) then
			do_pass2_:= do_pass2_ or 
			           mmc::ePROC( mmc::object, obj_ );
		else
			mmc::error( "No entry point for ".
			            expr2text(domtype(obj_)) 
			);
		end_if;
		
		mmc::object := "";
		i_       := i_ +1;
	end_while;
	

	#++ Conclude and close code-output-files ++++++++++++++++++++++++++++++#

		#++ ".c"   - C-code-file: functions +++++++++++++++++++++++++++#

	mmc::cl   ( mmc::c, "/*MERGE-*/" );
	mmc::close( mmc::c );
	
		#++ ".h"   - C-code-file: definements +++++++++++++++++++++++++#

	mmc::cl   ( mmc::h, "", "/*MERGE-*/" );
	mmc::close( mmc::h );
	
		#++ ".mdg" - MuPAD-code-file: generics ++++++++++++++++++++++++#

	mmc::cl   ( mmc::g, "#MERGE-#", "\"END_OF_TAB\" = NIL" );
	mmc::cpop ( mmc::g );
	mmc::cl   ( mmc::g, "):" );
	mmc::close( mmc::g );

		#++ ".log"  - log-file for debugging ++++++++++++++++++++++++++#

	if( mmc::loglevel > 0 ) then
		mmc::crl  ( mmc::l, "", " ENDE ", "" );
		mmc::close( mmc::l );
	end_if;
	
	#++ Perhaps we need a second pass +++++++++++++++++++++++++++++++++++++#
	
	if( do_pass2_ ) then
		mmc::mesg( "Second pass ..." );
		mmc::_m2c( TRUE ); 
	end_if;
end_proc:

# end of file #
