# $Date: 1994/06/15 14:19:31 $ $Author: andi $ $Revision: 1.2 $ #

# andi, 15.06.94 #

#++
open  - start a Maple slave

open( )
++#

maple::open := proc( )
local	command, bytes, i, PRETTY_PRINT;
begin
	if( sysname() <> "UNIX" ) then
		errro( "Sorry, only supported on UNIX systems" );
	end_if;
	if( maple::sdesc <> [] ) then
		error( "Use 'maple::close()' to close the current slave" );
	end_if;
	PRETTY_PRINT:= FALSE;
		
	#++ Check arguments and generate command-string to call Maple +++++++++#
	
	if  ( args(0) <> 1 ) then    #++ Call "maple" on local host +++++++++++#
		cmd:= maple::MAPLE;
	end_if;
	
	#++ Start and initialize the Maple slave ++++++++++++++++++++++++++++++#
	
	print( Unquoted, "Starting Maple ..." );
	maple::sdesc:= external("open","slave")( cmd );

		#++ Wait for Maple startup-message ++++++++++++++++++++++++++++#

	if( external("timeout","slave")(maple::sdesc,maple::TIMEOUT) ) then
		external("close","slave")( maple::sdesc );
		error( "No answer from Maple, can't continue" );
	end_if;

		#++ Send commands for initialisation ++++++++++++++++++++++++++#
		
	print( Unquoted, "Initializing Maple ..." );
	maple::put( 
		"interface( prettyprint=0 );\n".
		"interface( echo=0        );\n".
		"interface( quiet=true    );\n". 
		"1;\n" 
	): 

		#++ Wait for Maple's answers and remove them all ++++++++++++++#
		
	if( external("timeout","slave")(maple::sdesc,maple::TIMEOUT) ) then
		external("close","slave")( maple::sdesc );
		error( "No answer from Maple, can't continue" );
	end_if;
	maple::last:= maple::get();
	
	print( Unquoted, "Ready." ); 
end_proc:

# end of file #
