# $Date $ $Author $ $Revision $ #

# andi, 07/11/94 #

# mmc.mu -- the 'mmc' library for compiling MuPAD programs #

#++
User Functions:

mmc      - Compiler: MuPAD -> C [-> modul]
mmg      - Interface to the modul-generator
++#

#--
   This modul-compiler is still in a experimental state. 

--#

proc()
    local path;
begin

mmc           := domain():
mmc::name     := "mmc":
mmc::version  := "MMC  --  MuPAD-Modul-Compiler   --  V-0.0 Mar.94":
mmc::info     := "Library 'mmc': ".mmc::version:
mmc::interface:= { hold(compile), hold(mmg) }:

path:= pathname("mmc"):

##
#++ MMC - definitons and user-interface ++++++++++++++++++++++++++++++++#
##
mmc::usage := "usage:   mmc( modulname [, proc-set] [, option-string] )":

mmc::option  := { #"GENERIC"# }:           #++ Compiler options       ++#
mmc::loglevel:= 2:                         #++ Level of error-logging ++#
mmc::mmg_call:= TRUE:                      #++ Call of mmg ?          ++#
mmc::mmg_opt := "-v":                      #++ mmg-options            ++#

mmc::cnline := 80:                         #++ (Max.) length of line  ++#
mmc::cntab  := 4:                          #++ Length of a tabulator  ++#
mmc::cscreen:= "SCREEN":                   #++ Name of screen-fid     ++#
mmc::cscrid := 0:                          #++ Id   of screen-fid     ++#
mmc::chdl   := table():                    #++ Table of code-handle   ++#

mmc::modul   := "":                        #++ Name of current source ++#
mmc::c       := "":                        #++ Handle of .c-code-file ++#
mmc::h       := "":                        #++ Handle of .h-code-file ++#
mmc::g       := "":                        #++ Handle of .mdg file    ++#
mmc::l       := "":                        #++ Handle of log-file     ++#

mmc::warnings:= 0:                         #++ Number of warnings     ++#
mmc::errors  := 0:                         #++ Number of errors       ++#

mmc::objects := []:                        #++ Objects to compile     ++#
mmc::nobjects:= 0:                         #++ Number of objects      ++#
mmc::vobjects:= table():                   #++ Parser-info of objects ++#
mmc::object  := "":                        #++ Current object         ++#
mmc::stmt    := 0:
mmc::depth   := 0:                         #++ Current parser-depth   ++#

mmc::pname   := "parser":                  #++ Name of private Parser ++#
mmc::mfnum   := 1200:                      #++ mcode for mod.-func.   ++#

#++ User-interface and cross-compiler-entry ++#
mmc::compile:=	loadproc(mmc::compile,  path, "compile"):
mmc::new:= hold(mmc::compile):
mmc::mmg:=	loadproc(mmc::mmg,      path, "mmg"):
mmc::m2c:=	loadproc(mmc::m2c,      path, "m2c"):

#++ Code-output functions ++++++++++++++++++++#
mmc::copen:=	loadproc(mmc::copen,    path, "copen"):
mmc::cclose:=	loadproc(mmc::cclose,   path, "cclose"):
mmc::cpush:=	loadproc(mmc::cpush,    path, "cpush"):
mmc::cpop:=	loadproc(mmc::cpop,     path, "cpop"):
mmc::cl:=	loadproc(mmc::cl,       path, "cl"):
mmc::crl:=	loadproc(mmc::crl,      path, "crl"):

#++ Error functions ++++++++++++++++++++++++++#
mmc::error:=	loadproc(mmc::error,    path, "error"):
mmc::warn:=	loadproc(mmc::warn,     path, "warn"):
mmc::mesg:=	loadproc(mmc::mesg,     path, "mesg"):
 
#++ Controlling parser-attributes ++++++++++++#
mmc::acopy:=	loadproc(mmc::acopy,    path, "acopy"):
mmc::amerge:=	loadproc(mmc::amerge,   path, "amerge"):

#++ Controlling temp. C-variables ++++++++++++#
mmc::tvnew:=	loadproc(mmc::tvnew,    path, "tvnew"):
mmc::tvdel:=	loadproc(mmc::tvdel,    path, "tvdel"):

#++ Other functions ++++++++++++++++++++++++++#
mmc::isMF:=	loadproc(mmc::isMF,     path, "isMF"):

#++ Main-entry for named MuPAD-objects +++++++#
mmc::ePROC:=	loadproc(mmc::ePROC,    path, "ePROC"):

#++ Minimal set of parser-functions ++++++++++#
mmc::pPARSER:=	loadproc(mmc::pPARSER,  path, "pPARSER"):
mmc::pGENERIC:=	loadproc(mmc::pGENERIC, path, "pGENERIC"):

#++ Additional parser-functions ++++++++++++++#
mmc::pEXPR:=	loadproc(mmc::pEXPR,    path, "pEXPR"):
DOM_EXPR::parser:= hold(mmc::pEXPR):

mmc::p_stmtseq:=loadproc(mmc::p_stmtseq,path, "p_stmtseq"):
_stmtseq:= funcattr( _stmtseq, mmc::pname, mmc::p_stmtseq):


end_proc():

# end of file #
