# #
#++
	Paul Zimmermann   (modified 26.02.95 by Frank Postel)


	IA -- The domain for interval calculus

	IA( i1,i2 ) returns the interval i1..i2.
	i2 and i2 must be of type Constant but not complex quantifiers.
++#

IA := DomainConstructor::new(
# name #
    IA,
# arguments #
    [ ],
# local variables #
    [ ],
# initialisation #
    (if args(0) <> 0 then error("wrong no of args") end_if),
# super-domains #
    BaseDomain,
# categories #
    [ Field ],
# axioms #
    [ ],
# methods #
    "new" = proc(a,b)
    begin
	if testargs() then
	    if args(0) <> 2 then
		error("wrong no of args")
	    end_if;
	    if not testtype( a,Type::Constant ) or
	       not testtype( b,Type::Constant )
	    then
		error("invalid interval bounds")
	    end_if;
	    if domtype(sign(a)) = DOM_COMPLEX or
	       domtype(sign(b)) = DOM_COMPLEX
	    then
		error("expecting real bounds")
	    end_if
	end_if;

	new(this,a,b)
    end_proc,

    "print" = proc(r) begin extop(r,1)..extop(r,2) end_proc,

    "_plus" = proc(r,s) begin
	if args(0) > 2 then
	    return( this::_plus( r,this::_plus(args(i) $ hold(i)=2..args(0)) ) )
	end_if;
	if domtype(r) = this and domtype(s) = this then
	    new(this,extop(r,1)+extop(s,1),extop(r,2)+extop(s,2))
	else 
	    FAIL
	end_if
    end_proc,

    "sign" = proc(r) begin 
	if extop(r,1)>0 then 1 elif extop(r,2)<0 then -1 else 0 end_if
    end_proc,

    "_mult" = proc(r,s) local a,b,c,d; begin
	if args(0) > 2 then
	    return( this::_mult( r,this::_mult(args(i) $ hold(i)=2..args(0)) ) )
	end_if;
	if domtype(r) = this and domtype(s) = this then
	a:=extop(r,1); b:=extop(r,2); c:=extop(s,1); d:=extop(s,2);
	case sign(r),sign(s)
	of 1,1 do return(new(this,a*c,b*d))
	of 1,0 do return(new(this,b*c,b*d))
	of 1,-1 do return(new(this,b*c,a*d))
	of 0,1 do return(new(this,a*d,b*d))
	of 0,0 do return(new(this,min(a*d,b*c),max(a*c,b*d)))
	of 0,-1 do return(new(this,b*c,a*c))
	of -1,1 do return(new(this,a*d,b*c))
	of -1,0 do return(new(this,a*d,a*c))
	of -1,-1 do return(new(this,b*d,a*c))
	end_case
	else
	    FAIL
	end_if;
    end_proc,

    "negate" = proc(r) begin new(this,-extop(r,2),-extop(r,1)) end_proc,

    "invert" = proc(r) begin
	if sign(r)=0 then error("division by zero")
	else new(this,1/extop(r,2),1/extop(r,1))
	end_if
    end_proc,

    "square" = proc(r) begin
	case sign(r) 
	of 1 do return(new(this,extop(r,1)^2,extop(r,2)^2))
	of 0 do return(new(this,0,max(extop(r,1)^2,extop(r,2)^2)))
	of -1 do return(new(this,extop(r,2)^2,extop(r,1)^2))
	end_case
    end_proc,

    "_power" = proc(r,n) begin
	if n<0 then 1/r^(-n)
	elif n=1 then r
	elif n mod 2 = 0 then IA::_power(IA::square(r),n div 2)
	else r*IA::_power(IA::square(r),n div 2)
	end_if
    end_proc,

    "iszero" = fun(
	bool(iszero(extop(args(1),1)) and iszero(extop(args(1),2)))
    ),

    "one" = this::new(1,1),

    "zero" = this::new(0,0),

    "convert" = proc(e)
	local i1, i2;
    begin
	if domtype(e) = this then return( e )
	elif type(e) = "_range" then
	    i1 := op(e,1); i2 := op(e,2);
	    if testtype( i1,Type::Constant ) and
	       testtype( i2,Type::Constant )
	    then 
	        if domtype(sign(i1)) <> DOM_COMPLEX and
		   domtype(sign(i2)) <> DOM_COMPLEX
	        then
		    return( new(this,i1,i2) )
		end_if
	    end_if
	elif e = 1 then 
	    return( this::one )
	elif iszero(e) then
	    return( this::zero )
	end_if;
	FAIL
    end_proc,

    "convert_to" = proc(e,T)
    begin
	if domtype(T) = this then e
	elif type(T) = "_range" or T = "_range" then extop(e,1)..extop(e,2)
	else FAIL
	end_if
    end_proc
)():

# end of file #
