#++
Series - test for series expansions

Series(Puiseux)
Series(Laurent)
Series(Taylor)

Note: Series gives only a correct result, if the expression
      is generated by series!

Examples:
 
>> s:=series(sin(sqrt(x)),x): testtype(s, Type::Series(Puiseux));
 
                TRUE
 
>> s:=x+x^3*(-1/6)+x^5*1/120+O(x^6): testtype(s, Type::Series(Puiseux));
 
                FALSE

>> s:=series(1/sin(x),x): testtype(s, Type::Series(Laurent));

                TRUE

>> s:=series(sin(sqrt(x)),x): testtype(s, Type::Series(Laurent));

                FALSE

>> s:=series(sin(x),x): testtype(s, Type::Series(Taylor));
 
                TRUE
 
>> s:=series(1/sin(x),x): testtype(s, Type::Series(Taylor));
 
                FALSE

++#

Type::Series := proc(T) begin

    if args(0) <> 1 then
       error("wrong no of args")
    elif not contains({Puiseux, Laurent, Taylor}, T) then
       error("Unknown series expansion")
    end_if;

    new(Type, hold(Series), proc(t, x) begin
            case t
              of Puiseux do Type::Puiseux(x); break;
              of Laurent do Type::Laurent(x); break;
              of Taylor  do Type::Taylor(x);  break;
            end_case
          end_proc,
        args(1), FALSE)

end_proc:

Type::Puiseux := proc(x) begin 
  bool(type(x) = Puiseux)
end_proc:

Type::Laurent := proc(x) begin
  if not Type::Puiseux(x) then
     FALSE
   else
     bool(extop(x,1)=1 and not has(extop(x,4),extop(x,5)))
   end_if
end_proc:

Type::Taylor := proc(x) begin
  if not Type::Laurent(x) then
     FALSE
  else
     bool(extop(x,2) >= 0)
  end_if
end_proc:
