# $Date: 1994/06/28 14:59:55 $  $Author: kg $  $Revision: 1.1 $ #

#++
Product -- returns type expression to test products represented by sequences

Product(T1, T2,...)

T1, T2 - types

The type expression created returns TRUE if an expression is an expression
sequence where element ei has type Ti.
++#

Type::Product:= proc()
    local i;
begin
    if testargs() then
	if args(0) < 2 then error("wrong no of args") end_if;
	for i from 1 to args(0) do
	    if Type::isSeqType(args(i)) then
		error("can't test for sequences")
	    end_if
	end_for
    end_if;

    new(Type,
	hold(Product),
	(if map({args()}, domtype) = {Type} then
	    proc(t)
		local r, x, i;
	    begin
		x:= [ args(i) $ i=2..args(0) ];
		if nops(x) <> nops(t) then return(FALSE) end_if;
		r:= TRUE;
		for i from 1 to nops(x) do
		    case extop(t[i],2)(extop(t[i],3), x[i])
		    of FALSE do return(FALSE);
		    of FAIL do r:= FAIL;
		    end_case;
		end_for;
		r
	    end_proc
	else
	    proc(t)
		local r, x, i;
	    begin
		x:= [ args(i) $ i=2..args(0) ];
		if nops(x) <> nops(t) then return(FALSE) end_if;
		r:= TRUE;
		for i from 1 to nops(x) do
		    case testtype(x[i], t[i])
		    of FALSE do return(FALSE);
		    of FAIL do r:= FAIL;
		    end_case;
		end_for;
		r
	    end_proc
	end_if),
	[ args() ], TRUE)
end_proc:

# end of file #
