# $Date: 1994/06/28 14:59:53 $  $Author: kg $  $Revision: 1.1 $ #

#++
PolyOf - returns type expression to test polynomials

PolyOf(T [,n])

T - type of coefficients
n - number of indeterminates

The type expression created returns TRUE if an expression is a polynomial
(DOM_POLY) with coefficients of type 'T' and 'n' indeterminates.
If 'n' is missing then the number of indeterminates dosn't matter.
++#

Type::PolyOf:= proc(T)
begin
    if testargs() then
	case args(0)
	of 2 do
	    if domtype(args(2)) <> DOM_INT then
		error("illegal number of indets")
	    end_if;
	    if args(2) < 1 then
		error("illegal number of indets")
	    end_if;
	    break;
	of 1 do
	    break;
	otherwise error("wrong no of args");
	end_case;
	if Type::isSeqType(T) then
	    error("can't test for sequences")
	end_if
    end_if;

    new(Type,
	hold(PolyOf),
	(if domtype(T) = Type then
	    proc(t,x)
		local i, r;
	    begin
		if args(0) <> 2 then return(FALSE) end_if;
		if domtype(x) = DOM_POLY then
		    if nops(t) = 2 then
			if nops(op(x,2)) <> t[2] then return(FALSE) end_if;
		    end_if;
		    t:= t[1];
		    if iszero(x) then
			return(extop(t,2)(extop(t,3), coeff(x)))
		    end_if;
		    r:= TRUE;
		    for i from 1 to nterms(x) do
			case extop(t,2)(extop(t,3), nthcoeff(x,i))
			of FALSE do return(FALSE);
			of FAIL do r:= FAIL;
			end_case;
		    end_for;
		    r
		else
		    FALSE
		end_if;
	    end_proc
	else
	    proc(t,x)
		local i, r;
	    begin
		if args(0) <> 2 then return(FALSE) end_if;
		if domtype(x) = DOM_POLY then
		    if nops(t) = 2 then
			if nops(op(x,2)) <> t[2] then return(FALSE) end_if;
		    end_if;
		    t:= t[1];
		    if iszero(x) then
			return(testtype(coeff(x), t))
		    end_if;
		    r:= TRUE;
		    for i from 1 to nterms(x) do
			case testtype(nthcoeff(x,i), t)
			of FALSE do return(FALSE);
			of FAIL do r:= FAIL;
			end_case;
		    end_for;
		    r
		else
		    FALSE
		end_if;
	    end_proc
	end_if),
	[ args() ], FALSE)
end_proc:

# end of file #
