# $Date: 1994/09/12 09:08:11 $  $Author: kg $  $Revision: 1.2 $ #

#++
ListOf - returns type expression to test lists

ListOf(T [, min [, max ]])

T   - type of list elements
min - minimal number of elements (non-negative integer)
max - maximal number of elements (non-negative integer)

The type expression created returns TRUE if an expression is a list
with elements of type 'T' which has at least 'min' and at most 'max'
elements. If 'max' is missing the maximal number of list elements
dosn't matter. If 'min' and 'max' are missing the length of the list
dosn't matter.
++#

Type::ListOf:= proc(T)
begin
    if testargs() then
	case args(0)
	of 3 do
	    if domtype(args(3)) <> DOM_INT or domtype(args(2)) <> DOM_INT then
		error("illegal length")
	    end_if;
	    if args(3) < args(2) then
		error("illegal maximal length")
	    end_if;
	    if args(2) < 0 then
		error("illegal minimal length")
	    end_if;
	    break;
	of 2 do
	    if domtype(args(2)) <> DOM_INT then
		error("illegal minimal length")
	    end_if;
	    if args(2) < 0 then
		error("illegal minimal length")
	    end_if;
	    break;
	of 1 do
	    break;
	otherwise error("wrong no of args");
	end_case;
	if Type::isSeqType(T) then
	    error("can't test for sequences")
	end_if
    end_if;

    new(Type,
	hold(ListOf),
	(if domtype(T) = Type then
	    proc(t,x)
		local e, r;
	    begin
		if args(0) <> 2 then return(FALSE) end_if;
		if domtype(x) = DOM_LIST then
		    case nops(t)
		    of 3 do
			if nops(x) > t[3] then return(FALSE) end_if;
		    of 2 do
			if nops(x) < t[2] then return(FALSE) end_if;
		    end_case;
		    t:= t[1];
		    r:= TRUE;
		    for e in x do
			case extop(t,2)(extop(t,3), e)
			of FALSE do return(FALSE);
			of FAIL do r:= FAIL;
			end_case;
		    end_for;
		    r
		else
		    FALSE
		end_if;
	    end_proc
	else
	    proc(t,x)
		local e, r;
	    begin
		if args(0) <> 2 then return(FALSE) end_if;
		if domtype(x) = DOM_LIST then
		    case nops(t)
		    of 3 do
			if nops(x) > t[3] then return(FALSE) end_if;
		    of 2 do
			if nops(x) < t[2] then return(FALSE) end_if;
		    end_case;
		    t:= t[1];
		    r:= TRUE;
		    for e in x do
			case testtype(e, t)
			of FALSE do return(FALSE);
			of FAIL do r:= FAIL;
			end_case;
		    end_for;
		    r
		else
		    FALSE
		end_if;
	    end_proc
	end_if),
	[ args() ], FALSE)
end_proc:

# end of file #
