PRETTY_PRINT:=FALSE:

testsum := proc(f,x) # tests if sum(f,x) is correct #
local g,zero,a,b,err;
begin
   print("Summing ",f," wrt ",x);
   zero:=traperror((g:=sum(f,x)));
   if zero=0 then # no error #
   	zero:=invsum(g,x)-f;
   	zero:=normal(zero);
   end_if;
   if zero<>0 then print(f,x,g,zero); error("wrong sum") end_if;
end_proc:

invsum := proc(g,x) local t,c,j;
begin
   # no test should return sum(...) #
   if type(g)="function" and op(g,0)=hold(sum) then error("sum") end_if;
   if type(g)="_plus" then map(g,invsum,x)
   elif has(g,psi) then
      for t in indets(g,PolyExpr) do
         if has(t,psi) then break end_if
      end_for;
      c:=g/t; # coefficient #
      if nops(t)=1 then j:=0 else j:=op(t,2) end_if;
      c*(-1)^j*fact(j)/op(t,1)^(j+1)
   else subs(g,x=x+1)-g
   end_if
end_proc:

testsum2 := proc(f,x,res) # for definite sums #
local zero;
begin
   print("Summing ",f," for ",x);
   zero:=normal(sum(f,x)-res);
   if zero<>0 then error("wrong definite sum") end_if
end_proc:

testsum(1,k);

testsum(k,k);

testsum(x^2,x);

testsum(x^2,k);

testsum(1/k,k);

testsum(k+1/k,k);

testsum(1/kk,k);

testsum((-4*x-3*x^2-5)/(16*x+24*x^2+16*x^3+4*x^4+4),x);

testsum((x^2+1)/(x*(x+1)^4*(x+3)),x);

testsum(1/(x-1)/(x+1),x);

testsum(1/k/(k+1/2),k);

testsum(1/x^2/(x-1)/(x+3),x);

testsum(1/x/(x-a),x);

testsum(1/(x-1)/(x-a),x);

testsum(1/k/(k+3),k);

# from Mathematica manual #
testsum2(k^2*(1+k),k=1..n,n*(n+1)*(7*n+3*n^2+2)/12);

# from GKP page 223-227 #
s:=sum((-1)^k*binomial(n,k),k);
# should be (-1)^(k-1)*binomial(n-1,k-1) #
t:=(-1)^(k-1)*binomial(n-1,k-1);
expand(s-t);
subs(%,fact(n)=n*fact(n-1),fact(n-k+1)=(n-k+1)*fact(n-k),
	fact(k)=k*fact(k-1));
if normal(%)<>0 then error("GKP page 227") end_if;
t:=NIL:

# checks a non-summable function: GKP 227 #
s:=sum(binomial(n,k),k);
if type(s)<>"sum" then error("should be non-summable") end_if;

sum(binomial(n,m)*(-1)^m/2^m,m);

sum(1/k/2^(n+1),k);

sum(1/k/2^(n+1),k=1..n);

sum(binomial(n,m)*(-1/2)^m,m=k..n);

# check that Gosper's algorithm is really implemented as a decision procedure #
f:=binomial(n,k)/2^n-binomial(n+1,k)/2^(n+1):
g:=sum(f,k);
if normal(expand(subs(g,k=k+1)-g-f))<>0 then 
   error("Gosper's algorithm not completely implemented")
end_if;

testsum(k*a^k,k);

if normal(sum(x^k*y^(n-k),k=0..n)-(x^(n+1)-y^(n+1))/(x-y))<>0 then
   error("sum(x^k*y^(n-k),k=0..n)")
end_if;

sum(f(n),n); # caused MacMuPAD to crash #

sum(gamma((m+1)/2+n)*z^n,n=0..infinity); # caused MuPAD to crash #

sum( 1/(x^2-1),x=1..infinity ); # used to make an error #

sum(k^2/n,k=1..2); # used to make an error #

# example of Allan Donsig, sci.math.symbolic, Mon, 27 Feb 1995 #
# uses hypergeometric definite summation #
if sum(binomial(2*k-1,k)/(2*k-1)/8^k,k=0..infinity)<>-sqrt(2)/2 then error("sum") end_if;

if sum(t^2,t=RootOf(x^3+a*x^2+b*x+c,x))<>a^2-2*b then error("sum over RootOf") end_if;
if diff(sum(X2*ln(x+6*X2),X2=RootOf(108*X3^3-1,X3)),x)<>1/(x^3+2) then
	error("sum over RootOf") end_if;

g:=sum((-1)^(i+1)*(n-i+1)/(n+1)*binomial(2*n+2,i),i=0..n):
if normal(expand(g+binomial(2*n,n+1)*(n+1)*(-1)^(n+1)/n/(-n-1)))<>0 then error("sum") end_if;

if has(sum(binomial(n,k)+binomial(n+1,k),k),F) then error("sum") end_if;

# was doing singularity encountered. [gamma] #
if expand(sum(k*binomial(n,k),k=0..n))<>n*2^n/2 then error("sum") end_if;

if sum(k^x,x=0..m)<>(k*k^m-1)/(k-1) then error("sum") end_if;

quit
