PRETTY_PRINT:=FALSE:

if series(x,x=0)=FAIL then error("series") end_if;

testseries:=proc(__f__,x,n,i,ci) # coefficient of i should be ci #
local s;
begin
   s:=series(__f__,x,n);
   # normal needed because of PR-44 #
   if normal(coeff(s,i)-ci)<>0 then error("wrong expansion") end_if
end_proc:

testseries(exp(x),x,6,5,1/120);

testseries((1-x)/(1+3*x+x^2),x,15,14,1149851);

testseries(1/sqrt(1+3*x+x^2),x,15,14,3868357388907/33554432);

testseries(exp(sin(ln(1+tan(x)))),x,7,6,2/15);

testseries(exp(x+x^2),x,6,5,27/40);

testseries(1/sin(x),x,10,7,127/604800);

testseries(sqrt(sin(x)),x,10,17/2,-67/29030400);

testseries(f(x+1),x,6,5,D(D(D(D(D(f)))))(1)/120);

testseries(f(x),x,6,5,D(D(D(D(D(f)))))(0)/120);

testseries(f(x+x^2),x,6,5,D(D(D(f)))(0)/2+D(D(D(D(D(f)))))(0)/120+D(D(D(D(f))))(0)/6);

# Wester 91 #
s:=1/sqrt(1-(v/c)^2):
testseries(s,v,6,4,3/8/c^4);

# Wester 92 #
t:=1/series(s,v)^2;
if coeff(t,2)<>-1/c^2 then error("Wester 92") end_if;

# Wester 93 #
if series(sin(x),x)/series(cos(x),x)<>series(tan(x),x) then error("Wester 93") end_if;

# test for overloading of _plus and _mult #
s:=series(sin(x),x):
s+2,2+s;
s+x,x+s;
2*s,s*2;
x*s,s*x;

s:= series(exp(sin(x)),x,8):
map(s,sin);
map(s,normal);

series(cot(x),x);

# use taylor for multivariate expansions #
taylor(f(x,y),x,2);
if taylor(%,y,2)=FAIL then error("taylor") end_if;

series((ln(1/w+x)-x)/ln(1/w+ln(w))/w,w,4);

testseries(sin(2+x),x,6,5,cos(2)/120);

testseries(sinh(2+x),x,6,5,cosh(2)/120);

testseries(cos(2+x),x,6,5,-sin(2)/120);

testseries(cosh(2+x),x,6,5,sinh(2)/120);

series((sin(tan(x))-tan(sin(x)))/x^7,x); # used to make an error #

testseries(psi(x),x=infinity,7,5,-1/252); # formula 6.3.18 of AbSt #

testseries(psi(x,1),x=infinity,9,9,-1/30); # formula 6.4.12 #

testseries(psi(x,2),x=infinity,11,12,-5/6); # formula 6.4.13 #

testseries(psi(x,3),x=infinity,11,13,10); # formula 6.4.14 #

b:=series(sin(x),x,1): a:=series(cos(x),x,2):
c:=a+b: # used to be 1+x+O(x) #
if nops(extop(c,4))>extop(c,3)-extop(c,2) then error("series") end_if;

a:=series(ln(sinh(z)),z,2):
b:=series(ln(cosh(z+w)),z,2):
c:=a+b:
if nops(extop(c,4))>extop(c,3)-extop(c,2) then error("series") end_if;

series(ln(sinh(z))+ln(cosh(z+w)),z,2);
%-series(ln(sinh(z)*cosh(z+w)),z,2);
if expr(%)<>0 then error("series (Wester 95-96)") end_if;

s:=series(sin(x),x);
if revert(s)<>series(asin(x),x) then error("revert") end_if;

# not fully evaluated because of the name-space problem #
# testseries(int(exp(x^2),x),x,6,5,1/10); #

testseries(int(exp(x^2),x),x,6,0,0);

series(w^(1-E),w); # Segmentation Fault #

if series(erfc(x),x=infinity)=FAIL then error("series/erfc") end_if;
if series(-erfc(x),x=infinity)=FAIL then error("series/erfc") end_if;

traperror(series(sign(x),x)); # Memory freed twice #

s:=series(eint(x),x=infinity,6):
if nthmonomial(s,5)<>24*exp(-x)/x^5 then error("eint") end_if;
s:=series(eint(x),x=-infinity,6):
if nthmonomial(s,4)<>-6*exp(-x)/x^4 then error("eint") end_if;

quit
