PRETTY_PRINT:=FALSE:

testint := proc(f,x) local g;
begin
   print("Integrating",f,"with respect to",x);
   if traperror((g:=int(f,x)))<>0 then
      error("during integration")
   end_if;
   if combine(normal(diff(g,x)-f),sincos)<>0 then
      error("derivative of integral does not simplify to the function")
   end_if;
end_proc:

testint(1/x,x):

testint(1/(1+x^3),x):

int((x*exp(x))^(1/2),x); # PR 57 #

int(f1^(1-z) / (f2^2 - f1^2)^(1/2),f1); # PR 53 #

testint(sin(x),x);

testint(cos(x),x);

if int(abs(x),x)<>x*abs(x)/2 then error("int") end_if;

# Wester 90 #
if int(int(int(1,z=0..c*(1-x/a-y/b)),y=0..b*(1-x/a)),x=0..a)<>a*b*c/6 then error("int") end_if;

float(int(sin(x),x=a..b));

k:=0:
int(cos(t)*sin(t)/exp(t*2*I)*1/2*I,t); # test problems with variable k in INTLIB #

# example on page 551 of Geddes and al #
if int(1/(exp(x)+1),x)<>x-ln(exp(x)+1) then error("int") end_if;

# example on page 481 #
if int(-1/(x^2+2*x+1),x)<>1/(x+1) then error("int") end_if;

# example 11.2 page 481 #
testint(1/(x^3+x),x);

testint(1/(x^2-2),x);

# example 11.4 page 485 #
f:=(441*x^7+780*x^6-2861*x^5+4085*x^4+7695*x^3+3713*x^2-43253*x+24500)/
(9*x^6+6*x^5-65*x^4+20*x^3+135*x^2-154*x+49):
int(f,x);

testint(1/(x^2-8),x); # uses ln #

testint(1/(x^2+8),x); # uses atan #

testint(1/(x^2+a),x); # uses atan (a positive by default) #

testint(1/(1+3*x+x^5),x); # uses sum/RootOf notation #

testint(sin(x)^3*cos(x)^2,x); # trigonometrics #

f:=((-cos(t)*sin(t)*sin(t*2))
+ cos(t)^3*sin(t)*sin(t*2)*2)/(cos(t*2) + cos(t)^2*cos(t*2)
 *(-4) + cos(t)^4*cos(t*2)*4 + cos(t)^2*sin(t)^2*cos(t*2)*4):
if combine(int(f,t))<>t/4-sin(4*t)/16 then error("int") end_if;

a:=int(1/sin(u),u);
a; # division by zero #


quit
