# $Date: 1995/05/26 08:01:39 $ $Author: kg $ $Revision: 1.5 $ #

# kg, 16/12/94 #

#++
sqrfree -- square-free factorization of polynomials

sqrfree(p)

p - polynomial or polynomial expression

Returns the square-free factorization of a polynomial or expression
over the rationals.

If the polynomial is of type Expr ist coefficients must be rationals.
If the polynomial is of type IntMod(n) then n must be a prime number.
If the coefficients are from a domain that domain must be a UFD of 
characteristic 0 or a finite field.

If the coefficients are from a finite field then the polynomial must
be univariate.
++#

sqrfree:=proc(p)
    local t, f, i, j;
begin
    if args(0) <> 1 then error("wrong no of args") end_if;
    if p::sqrfree <> FAIL then return(p::sqrfree(p)) end_if;
    if domtype(p) = DOM_POLY then
        if testargs() then
            t:= op(p,3);
            if domtype(t) = DOM_DOMAIN then
                if t::hasProp <> FAIL then
                    if t::hasProp(FactorialDomain) then
                        if t::characteristic <> 0 then
			    if t::hasProp(Field) then
			        if nops(op(p,2)) <> 1 then
			            error("not an univariate polynomial")
			        end_if;
			        if not t::hasProp(IntegerMod) then
			            error("not a finite field")
			        end_if
			    else
			        error("not a Field")
			    end_if
                        end_if
                    else
                        error("not a FactorialDomain")
                    end_if
                end_if
            else
                if t = hold(Expr) then
                    if not testtype(p, Type::PolyOf(Type::Rational)) then
                        error("not a rational polynomial")
                    end_if
                elif not isprime(op(t,1)) then
                    error("no prime modulus")
                elif nops(op(p,2)) <> 1 then
                    error("not an univariate polynomial")
                end_if
            end_if
        end_if;
    	f:= faclib::sqrfree_poly(p)
    else
    	f:= faclib::factor_expr(p, faclib::sqrfree_poly)
    end_if;
    
    # re-collect factors with equal powers #
    t:= table();
    for i from 3 to nops(f) step 2 do
    	if contains(t, f[i]) then
    	    t[f[i]]:= t[f[i]] * f[i-1]
    	else
    	    t[f[i]]:= f[i-1]
    	end_if
    end_for;
    [ f[1], (op(t, [j,2]), op(t, [j,1])) $ j=1..nops(t) ]
end_proc:

# end of file #
