solve := proc(eqs,vars,lev)
local sol;
begin
   # first try overloading #
   if eqs::solve<>FAIL then return(eqs::solve(args())) end_if;
   case type(eqs) 
   of DOM_SET do
      if args(0)<2 then vars:=indets(eqs) end_if;
      return(stdlib::solve_sys(eqs,vars))
   of "_equal" do eqs:=op(eqs,1)-op(eqs,2)
   end_case;
   # only one equation #
   if args(0)<2 then 
      vars:=indets(eqs);
      if nops(vars)<>1 then error("invalid arguments") end_if;
      vars:=op(vars)
   elif type(vars)<>DOM_IDENT then error("invalid arguments") 
   end_if;
   sol:=stdlib::solve_eq(eqs,vars,lev);
   if type(sol)="solve" then sol
   else [sol]
   end_if
end_proc:

stdlib::solve_eq:=proc(eq,x,lev)
begin
   case domtype(eq)
   of DOM_IDENT do # solve(x,x) #
   of DOM_EXPR do
      if testtype(eq,Type::PolyExpr(x)) then
	 if type(lev)<>DOM_INT then lev:=4 end_if;
	 return(stdlib::solve_poly(poly(eq,[x]),x,lev))
      else return(stdlib::solve_isolate(eq,0,x))
      end_if;
   of DOM_POLY do
      if type(lev)<>DOM_INT then lev:=4 end_if;
      return(stdlib::solve_poly(eq,x,lev))
   otherwise
      if eq::constructor=DistributedPolynomial then
         if type(lev)<>DOM_INT then lev:=4 end_if;
         return(stdlib::solve_poly(op(eq),x,lev))
      end_if;
   end_case;
   null()
end_proc:

# x appears only in lhs #
stdlib::solve_isolate := proc(lhs,rhs,x) local l,i;
begin
   if lhs=x then return(rhs) end_if;
   case type(lhs)
   of "_plus" do
      # Note: x-op(x,1) <> subsop(x,1=null()) #
      #
      l:=select([op(lhs)],has,x);
      if nops(l)=1 then return(stdlib::solve_isolate(l[1],rhs-(lhs-l[1]),x)) end_if;
      #
      for i from 1 to nops(lhs) do
          if has(op(lhs,i),x) then
              l:= op(lhs,i);
              lhs:= subsop(lhs,i=null());
              if has(lhs,x) then lhs:= lhs+l; break end_if;
              return(stdlib::solve_isolate(l,rhs-lhs,x))
          end_if;
      end_for;
      break;
   of "_mult" do
      #
      l:=select([op(lhs)],has,x);
      if nops(l)=1 then return(stdlib::solve_isolate(l[1],rhs/(lhs/l[1]),x)) end_if;
      #
      for i from 1 to nops(lhs) do
          if has(op(lhs,i),x) then
              l:= op(lhs,i);
              lhs:= subsop(lhs,i=null());
              if has(lhs,x) then lhs:= lhs*l; break end_if;
              return(stdlib::solve_isolate(l,rhs/lhs,x))
          end_if;
      end_for;
      break;
   of "_power" do
      if not has(op(lhs,2),x) then 
         return(stdlib::solve_isolate(op(lhs,1),rhs^(1/op(lhs,2)),x))
      else 
         return(stdlib::solve_isolate(op(lhs,2)*ln(op(lhs,1)),ln(rhs),x))
      end_if
   of "atan" do return(stdlib::solve_isolate(op(lhs),tan(rhs),x))
   of "ln" do return(stdlib::solve_isolate(op(lhs),exp(rhs),x))
   end_case;
   hold(solve)(lhs=rhs,x)
end_proc:

# solve a polynomial in explicit form, or returns RootOf(...) for factors of
   degree>solve::maxdeg,
   returns
1) either x=1
2) either x=1,x=2,...
3) either x=x
4) or null() if there is no solution

   solve equations up to degree lev exactly
#
stdlib::solve_poly := proc(p,x,lev) # p is supposed to be of type DOM_POLY, x is the variable #
local d,l,s,i;
begin
   d:=degree(p,x);
   if d=0 then if iszero(p) then x else null() end_if
   elif d=1 then 
      if op(p,2)=[x] then -coeff(p,x,0)/coeff(p,x,1)
      else -expr(coeff(p,x,0))/expr(coeff(p,x,1))
      end_if
   else # d >=2 #
      if lev<2 then return(RootOf(p,x)) end_if;
      userinfo(1,"trying to factor polynomial of degree ".d);
      userinfo(2,"polynomial is",p);
      if traperror((l:=factor(p)))<>0 then 
         l:=[1,p,1] # can happen in solve(1/(x^2-1)*(-x^2-y^2+1),y) #
      end_if;
      s:=null();
      for i from 1 to nops(l) div 2 do
         s:=s,stdlib::solve_poly_irred(l[2*i],x,lev)$l[2*i+1]
      end_for;
      s
   end_if
end_proc:

stdlib::solve_poly_irred := proc(p,x,lev) # p is irreducible #
local a,b,c,d;
begin
   d:=degree(p,x);
   userinfo(2,"solving irreducible polynomial of degree",d);
   if d=1 then -coeff(p,x,0)/coeff(p,x,1)
   elif d=2 and lev>=2 then
      a:=coeff(p,x,2); b:=coeff(p,x,1); c:=coeff(p,x,0);
      if op(p,2)<>[x] then a:=expr(a); b:=expr(b); c:=expr(c) end_if;
      d:=sqrt(b*b-4*a*c); (-b+d)/2/a,(-b-d)/2/a
   elif d=3 and lev>=3 then stdlib::solve_poly3(p,x)
   else
      userinfo(1,"trying polynomial decomposition");
      a:=[decompose(p,x)];
      if nops(a)=1 then # no decomposition #
         userinfo(1,"decomposition failed");
	 if d=4 and lev>=4 then stdlib::solve_poly4(p,x)
	 else RootOf(expr(p),x)
	 end_if
      else
         userinfo(1,"decomposition succeeded");
         b:=[stdlib::solve_poly(a[1],x,lev)]; a[1]:=NIL;
         for c in a do
            b:=map(b,poly,[x]);
            b:=map(b,_plus,-c);
            b:=map(b,stdlib::solve_poly,x,lev);
         end_for;
         op(b)
      end_if
   end_if
end_proc:

stdlib::solve_poly3 := proc(p,x) local a,b,c,d,q,t1,t3,t5,t6,t9,t11,t13,X1,X2,X3;
begin
   userinfo(2,"entering degree 3 routine");
   # input form a*x^3+b*x^2+c*x+d #
   a:=coeff(p,3); b:=coeff(p,2); c:=coeff(p,1); d:=coeff(p,0);
   # convert to x^3+b*x^2+c*x+d #
   b:=b/a; c:=c/a; d:=d/a;
   # then to X^3+p*X+q using the change of variable x=X-b/3 #
   p:=c-b^2/3; q:=d-b*c/3+2*b^3/27;
   if p=0 then
      X1:=(-q)^(1/3); t13:=3^(1/2)*X1;
   else
      t1:=p^2; t3:=q^2; t5:=sqrt(4*t1*p+27*t3); t6:=3^(1/2);
      t9:=(-q/2+t5*t6/18)^(1/3); t11:=p/t9; t13:=t6*(t9+t11/3); 
      X1:=t9-t11/3; 
   end_if;
   X2:=-X1/2+I*t13/2; X3:=-X1/2-I*t13/2;
   X1-b/3,X2-b/3,X3-b/3
end_proc:

stdlib::solve_poly4 := proc(P,x) 
local b,p,q,r,t1,t2,t3,t4,t5,t8,t11,t14,t15,t16,t17,t18,t19,t20,t21,t22,t23,t24,
t25,t26,t27,t28,t29,t31,t33,t34,t36,t38,t39,t40,t42,t44,X1,X2,X3,X4;
begin
   # first make p monic #
   P:=multcoeffs(P,1/lcoeff(P)); # now P=x^4+b*x^3+c*x^2+d*x+e #
   b:=coeff(P,3)/4;
   P:=P(x-b); # make the change x=X-b/4 so that coeff of X^3 vanishes #
   p:=coeff(P,x,2); q:=coeff(P,x,1); r:=coeff(P,x,0); # now P=X^4+p*X^2+q*X+r #
   t1:=r*p; t2:=q^2; t3:=p^2; t4:=t3*p; t5:=r^2; t8:=t3^2; t11:=t2^2;
   t14:=sqrt(128*t5*t3-256*t5*r-16*r*t8-144*t1*t2+27*t11+4*t2*t4);
   t15:=3^(1/2); t16:=t14*t15; t17:=-4/3*t1+t2/2+t4/27+t16/18;
   t18:=t17^(1/3); t19:=p*t18; t20:=t18^2; t21:=-6*t19+9*t20+12*r+t3;
   t22:=sqrt(t21); t23:=t17^(1/6); t24:=1/t23; t25:=t22*t24; t26:=t19*t22;
   t27:=t22*t20; t28:=t22*r; t29:=t22*t3; t31:=sqrt(27*t2-72*t1+2*t4+3*t16);
   t33:=6^(1/2); t34:=q*t31*t33; t36:=sqrt(-12*t26-9*t27-12*t28-t29-3*t34);
   t38:=t21^(1/4); t39:=1/t38; t40:=t36*t24*t39;
   t42:=sqrt(3*t34-12*t26-9*t27-12*t28-t29); t44:=t42*t24*t39;
   X1:=t25/6+t40/6; X2:=t25/6-t40/6;
   X3:=-t25/6+t44/6; X4:=-t25/6-t44/6;
   X1-b,X2-b,X3-b,X4-b
end_proc:

stdlib::solve_sys := proc(sys,unk)
local newsys,eq;
begin
   if (newsys:=stdlib::solve_islinear(sys,unk))<>FALSE then [linsolve(newsys,unk)]
   elif (newsys:=stdlib::solve_isalgebraic(sys,unk))<>FALSE then [stdlib::solve_algebraic(newsys,unk)]
   else
      if nops(unk)=1 and nops(sys)=1 then
         eq:=op(sys);
         if type(eq)="_equal" then eq:=op(eq,1)-op(eq,2) end_if;
         newsys:=stdlib::solve_eq(eq,op(unk),1);
         if type(newsys)<>solve then
            return(map([newsys],fun([op(unk)=args(1)])))
         end_if
      end_if;
      hold(solve)(sys,unk)
   end_if
end_proc:

algsolve := proc(sys,unk,dom)
begin
   if type(sys)<>DOM_SET then error("invalid arguments") end_if;
   sys:=map(sys,func((if type(x)="_equal" then op(x,1)-op(x,2) else x end_if),x));
   if args(0)<3 then dom:=null() end_if;
   stdlib::solve_algebraic(sys,unk,dom)
end_proc:

stdlib::solve_algebraic:=proc(sys,unk,dom) local g,r,sol,x,i,args3;
begin
   args3:=bool(args(0)>=3); # because traperror does not restore args #
   userinfo(1,"entering solver for algebraic systems");
   loadlib("groebner");
   if not args3 then dom:=Expr end_if; # default domain #
   sys:=map([op(sys)],poly,[op(unk)],dom);
   if traperror((g:=groebner::gbasis(sys,LexOrder,Reorder)))<>0 then
      if args3 then return(FAIL) end_if; # given domain does not work #
      userinfo(1,"computation of Groebner basis over the rationals failed");
      # non rational coefficients #
      loadlib("domains"):
      sys:=map(sys,subsop,3=ExpressionField(normal));
      g:=groebner::gbasis(sys,LexOrder,Reorder);
   end_if;
   userinfo(2,"Groebner basis is",map(g,expr));
   if expr(g[1])=1 then null() # no solution #
   else
      # the elements of the basis g are sorted according
        to the term-ordering, thus the last one
        should contain only one variable #
      sol:=null();
      for i from nops(g) downto 1 do
         r:=g[i];
         x:=indets(expr(r)) intersect unk;
         if nops(x)=0 then return(null()) end_if;
         x:=op(x,1);
         unk:=unk minus {x};
         sol:=x=stdlib::solve_poly(poly(expr(r),[x]),x,1), sol
      end_for;
      [sol]
   end_if
end_proc:

# returns FALSE if sys is not a linear system with respect to unk,
  otherwise sys where all equalities a=b have been replaced by a-b
  and all 0 equations have been deleted
#
stdlib::solve_islinear := proc(sys,unk)
local eq,u,l,newsys;
begin
   l:=[op(unk)];
   newsys:={};
   for eq in sys do
      if type(eq)="_equal" then eq:=op(eq,1)-op(eq,2) end_if;
      for u in unk do
         if not testtype(eq,Type::PolyExpr(u)) then return(FALSE) end_if
      end_for;
      if degree(eq,l)>1 then return(FALSE) end_if;
      newsys:=newsys union {eq};
   end_for;
   newsys
end_proc:

# returns FALSE if sys is not an algebraic system with respect to unk,
  otherwise sys where all equalities a=b have been replaced by a-b
  and all 0 equations have been deleted
#
stdlib::solve_isalgebraic := proc(sys,unk)
local eq,u,l,newsys;
begin
   l:=[op(unk)];
   newsys:={};
   for eq in sys do
      if type(eq)="_equal" then eq:=op(eq,1)-op(eq,2) end_if;
      for u in unk do
         if not testtype(eq,Type::PolyExpr(u)) then return(FALSE) end_if
      end_for;
      newsys:=newsys union {eq};
   end_for;
   newsys
end_proc:

solve:= funcattr(solve, "type", "solve"):
solve:= funcattr(solve, "print", "solve"):

linsolve := proc(sys,unk) # using linalg #
local sol,i,sp,j,n,ns,t;
begin
   loadlib("linalg");
   sol:=linalg::linearSolve(
	op(linalg::expr2Matrix(sys,unk,ExpressionField(normal)))
   );
   if sol=[] then null()
   elif nops(sol) = 2 then # no unique sol #
	sp := sol[1]; ns := sol[2];
	n := nops(unk);
	sys := [];
	j := 1;
	for i from 1 to nops(ns) do
	    t := op(ns,i);
	    while expr(t[j]) <> 1 and j <= n do j := j + 1 end_while;
	    if j <= n then sys := append(sys,op(unk,j)) end_if
	end_for;
	n := nops(ns);
	j := NIL;
	sol := {};
	for i from 1 to nops(unk) do
	    if contains(sys,op(unk,i)) > 0 then next end_if;
	    sol := sol union {op(unk,i)=
	        _plus(expr(sp[i]),op(sys,j)*expr(op(ns,j)[i])$j=1..n)
	    }
	end_for;
	sol
   else
	{op(unk,i)=expr(sol[i])$i=1..nops(unk)}
   end_if
end_proc:

solve:= funcattr(solve, "float", proc(p,X)
begin
   if args(0)>2 then error("wrong number of arguments") end_if;
   case domtype(p)
   of DOM_EXPR do
      if type(p)="_equal" then p:=op(p,1)-op(p,2) end_if;
      if args(0)=0 then error("wrong number of arguments")
      elif args(0)=1 then
         X:=indets(p) minus {E,PI,EULER};
         if nops(X)<>1 then error("more than one indeterminate") end_if;
         X:=op(X);
      else
         if indets(p) minus {E,PI,EULER}<>{X} then 
            error("only univariate equation allowed")
         end_if;
      end_if;
      if testtype(p,Type::PolyExpr(X)) then p:=poly(p,[X]) end_if;
      break
   of DOM_POLY do
      if nops(op(p,2))<>1 then error("only univariate polynomial allowed") end_if;
      X:=op(op(p,2));
      break;
   otherwise return(hold(float)(hold(solve)(args())))
   end_case;
   if domtype(p)=DOM_POLY then [_fsolve_Sqrfpoly(p,DIGITS,X)]
   else hold(float)(hold(solve)(args()))
   end_if
end_proc):

_fsolve_Sqrfpoly:=loadproc(_fsolve_Sqrfpoly,pathname("NUMERIC"),"solvepol"):
