# $Date: 1995/02/22 13:03:03 $ $Author: kg $ $Revision: 1.4 $ #

# kg, 27/12/94 #

#++
setuserinfo -- set information level for procedure

setuserinfo(p [,lev])

p   - procedure or name of procedure or 'Any'
lev - level of information (positive integer)

Sets the information level of the procedure p to lev. If lev
is missing the level for p is set to 0.

If p is 'Any' then the global information level is set to lev
or to 0 resp.

See 'userinfo'.
++#

setuserinfo:= proc(pnam,lev)
begin
    if testargs() then
    	if args(0) > 2 or args(0) < 1 then error("wrong no of args") end_if;
    	if args(0) = 2 then
    	    if domtype(lev) <> DOM_INT then error("illegal level") end_if;
    	    if lev < 0 then error("illegal level") end_if;
    	end_if
    end_if;
    
    # create level table #
    if stdlib::userinfo_level = FAIL then
        stdlib::userinfo_level:= table()
    end_if;
    
    # get proc name if argument is proc #
    if domtype(pnam) = DOM_PROC then
    	pnam:= op(pnam, 6)
    end_if;
    
    # store level for proc #
    if args(0) = 1 then
	stdlib::userinfo_level[pnam]:= NIL
    else
    	stdlib::userinfo_level[pnam]:= lev
    end_if;
    null();
end_proc:

# end of file #
