rsolve := proc() local i;
begin
   hold(rsolve)(args())
end_proc:

Rsolve::holonomic := proc(eq,inits,u,n,ord)
local r,p,q,lp,lq,i0;
begin
   userinfo(1,"solving recurrence of order ",ord);
   userinfo(2,"solving recurrence",eq,"with initial conditions",inits);
   if ord=1 then 
      r:=normal(subs(op(eq,2),n=n-1)/u(n-1)); # r = u(n)/u(n-1) #
      if not has(r,u(n)) then # homogeneous equation #
	 if not has(r,n) then return(subs(u(0),op(inits))*r^n)
	 elif testtype(r,Type::RatExpr(n)) then
	    p:=numer(r);
	    q:=denom(r);
            userinfo(2,"hypergeometric recurrence with ratio",p/q);
            i0:=max(0,op(sharelib::iroots(q,FALSE)));
            # lp:=lcoeff(p,[n]); lq:=lcoeff(q,[n]); #
            p:=Rsolve::unratio(p,n,i0);
            q:=Rsolve::unratio(q,n,i0);
            if p<>FAIL and q<>FAIL then return(p/q*subs(u(i0),op(inits))) end_if
	 end_if
      end_if
   end_if;
   hold(rsolve)({eq} union inits,u(n))
end_proc:

# e is a polynom in n
  output f such that f(n)=e(n)*e(n-1)*...*e(i0+1) with i0>=0 #
Rsolve::unratio := proc(e,n,i0)
local a,b;
begin
   if testtype(e,Type::PolyExpr(n)) then
      case degree(e,n)
      of 0 do return(e^(n-i0))
      of 1 do 
         a:=coeff(e,n,1); b:=coeff(e,n,0);
         # product(a*k+b,k=i0+1..n) = a^(n-i0)*product(k+b/a,k=i0+1..n) #
         b:=b/a; a:=a^(n-i0);
         if testtype(b,Type::NonNegInt) then
            return(a*fact(n+b)/fact(i0+b))
         else return(a*expand(fact(n+b))/gamma(i0+b+1))
         end_if
      end_case
   end_if;
   FAIL
end_proc:


