# $Date: 1994/05/31 13:26:28 $  $Author: linus $  $Revision: 1.1 $ #
#++

random - random number generator
   
random()   
random(range)   
random(integer)   
   
range   - an integer range
integer - a non-negative integer
   
random()     returns a 12 digit non-negative random integer.
random(a..b) returns a procedure  which, when called, generates 
             random integers in the range a..b.
random(n)    is the abbreviated form of rand(0..n-1).
   
The global variable SEED can be used to alter the sequence of random 
numbers  generated, by setting it to any non-zero integer.

++#

random := proc(r)
  local a, p, s, generator,
	# define as local to hide them: #
        _OFFSET, _DIVISOR, _CONCATS, _MODULUS, _MULTIPLIER, _SHIFT;
begin

    generator := proc(input, p)
      local i, o, r, x;
    begin
      if type(input) = "_range" then
         o := op(input, 1);
         r := op(input, 2);
         if not (domtype(o)=DOM_INT and domtype(r)=DOM_INT) or (r < o) then
            error("invalid range")
         end_if;
         r := r-o+1
      elif domtype(input)=DOM_INT and (0 < input) then 
	     o := 0; r := input
      else 
	     error("invalid arguments")
      end_if;
      x := p; i := 1;
      while x < r do  
	     x := p*x; i := i+1 
	  end_while;
      _OFFSET = o,_DIVISOR = r,_CONCATS = i-1
    end_proc;
	
    p := 999999999989;
    a := 427419669081;
    s := 1000000000000;
    if not anames(SEED) then SEED := 1 end_if;
    if args(0) = 0 then 
       SEED := (a * SEED) mod p;
    else
        subs(
            proc()
              local i, t;
            begin
                SEED := (_MULTIPLIER * SEED) mod _MODULUS;
                t := SEED;
                for i from 1 to _CONCATS do
                    SEED := (_MULTIPLIER * SEED) mod _MODULUS;
                    t := _SHIFT * t + SEED
                end_for;
                (t mod _DIVISOR) + _OFFSET
            end_proc,
	    [ _MODULUS = p,_MULTIPLIER = a,_SHIFT = s,generator(r,p) ]
        )
    end_if
end_proc:
