radsimp := proc(e)
local p,q,f,abr,a,b,r,qq;
begin
   if e::radsimp <> FAIL then return( e::radsimp(args()) ) end_if;

   if domtype(e)=DOM_EXPR then
      if contains({"_plus","_mult","_power"},type(e)) then
	 p:=numer(e); q:=denom(e);
	 if type(q)="_plus" then
	    abr:=_radsimp_match2sqrt(q); # q = a+b*sqrt(r) #
	    if abr<>FAIL then
	       a:=abr[1]; b:=abr[2]; r:=abr[3];
	       e:=expand(p*(a-b*sqrt(r)))/(a^2-b^2*r)
	    end_if
	 end_if;
	 if testtype(e,Type::Constant) then e:=_radsimp_denest(e) end_if;
      else e:=map(e,radsimp)
      end_if
   end_if;
   e
end_proc:

_radsimp_match2sqrt := proc(f) # match a+b*sqrt(r) and returns a,b,r #
local a,b,r,i,j,br;
begin
    if type(f)="_plus" then
      b:=op(f,1); j:=1;
      for i from 2 to nops(f) do
         if _radsimp_sqrtdepth(op(f,i))>_radsimp_sqrtdepth(b) then b:=op(f,i); j:=i end_if
      end_for;
      # a:=f-b; #
      a:=subsop(f, j=null());
      f:=b;
      # f should be b*sqrt(r) #
      if (br:=_radsimp_matchmultsqrt(f))<>FAIL then return(a,br) end_if
    end_if;
    FAIL
end_proc:

_radsimp_matchsqrt := proc(e) # matches sqrt(f) and returns f, or FAIL #
begin
   if type(e)="_power" then
      if op(e,2)=1/2 then return(op(e,1)) end_if
   elif type(e)="sqrt" then return(op(e))
   end_if;
   FAIL
end_proc:

# from Decreasing the Nesting Depth of Expressions Involving Square Roots
   by Borodin, Fagin, Hopcroft and Tompa, JSC 1, 1985, pages 169-188 
#
_radsimp_denest := proc(e) local l;
begin
   userinfo(2,"trying to denest",e);
   if _radsimp_matchsqrt(e)<>FAIL then
      e:=op(e,1);
      if type(e)=DOM_INT then return(simplify(e^(1/2))) end_if;
      e:=sqrt(_radsimp_denest(e));
      if traperror((l:=_denest_denest(_radsimp_sqrtdepth(e),1,[e])))=0 then e:=op(l) end_if
   elif contains({"_plus","_mult"},type(e)) then
      e:=map(e,_radsimp_denest);
      if type(e)="_plus" and _radsimp_sqrtdepth(e)>=2 then e:=_denest_linear(e)
      elif type(e)="_mult" then e:=simplify(expand(e))
      end_if
   end_if;
   e
end_proc:

# algorithm of section 5 pages 184-185 #
_denest_linear := proc(e) # e is a linear combination of (nested) square roots #
local h,i,j,d,br,pij,k,dp,li,lj;
begin
   if type(e)<>"_plus" then return(e) end_if;
   h:=nops(e);
   for i from 1 to h do
      d[i]:=_radsimp_sqrtdepth(op(e,i));
      if d[i]<2 then br[i]:=FAIL else br[i]:=_radsimp_matchmultsqrt(op(e,i)) end_if;
   end_for;
   for i from 1 to h-1 do
      if br[i]=FAIL then next end_if;
      li:=br[i][1];
      for j from i+1 to h do
         # does e[i]*e[j] denest ? #
         if br[j]=FAIL then next end_if;
         lj:=br[j][1];
         pij:=expand(br[i][2]*br[j][2])^(1/2);
         dp:=_radsimp_sqrtdepth(pij);
         if dp=0 then k:=pij else k:=op(_denest_denest(dp,1,[pij])) end_if;
         if _radsimp_sqrtdepth(k)<dp then
            e:=e-op(e,i)-op(e,j)+(li+radsimp(k*lj/br[i][2]))*sqrt(br[i][2]);
            return(_denest_linear(e))
         end_if
      end_for
   end_for;
   e
end_proc:

# algorithm DENEST of section 2, page 177 #
# n and m are integers, nested[1..m] is an array of nested formulae #
_denest_denest := proc(n,m,nested)
local i,N,a,b,r,d,s;
begin
   userinfo(1,"depth=",n);
   userinfo(2,"nested=",nested);
   if n=1 then nested # replaces sqrt(x^2) by x #
   else
      # assume nested[i] = sqrt(a[i]+b[i]*sqrt(r)) #
      N:=_denest_match2sqrt(nested[1]);
      a[1]:=N[1]; b[1]:=N[2]; r:=N[3];
      userinfo(1,"matched sqrt(a+b*sqrt(r))");
      userinfo(2,"with a=",N[1],"b=",N[2],"r=",N[3]);
      for i from 2 to m do
         N:=_denest_match2sqrt(nested[i]);
         a[i]:=N[1]; b[i]:=N[2];
      end_for;
      N:=[hold(_power)(expand(a[i]^2-b[i]^2*r),1/2)$hold(i)=1..m,hold(_power)(r,1/2)];
      d:=_denest_denest(n-1,m+1,level(N,2));
      if _radsimp_sqrtdepth(N[m+1])<>_radsimp_sqrtdepth(d[m+1]) then # sqrt(r) denested #
         [sqrt(a[i]+b[i]*d[m+1])$hold(i)=1..m]
      else
         for i from 1 to m do
            if _radsimp_sqrtdepth(N[i])<>_radsimp_sqrtdepth(d[i]) then
               s:=2*(a[i]+d[i]);
               nested[i]:=sqrt(s)/2+simplify(b[i]*sqrt(r*s),sqrt)/s;
            end_if
         end_for;
         nested
      end_if
   end_if
end_proc:

_denest_match2sqrt := proc(e) # match sqrt(a+b*sqrt(r)) and returns a,b,r #
local f,a,b,r,i,br;
begin
   if (f:=_radsimp_matchsqrt(e))<>FAIL then _radsimp_match2sqrt(f)
   else error("does not match")
   end_if
end_proc:

# matches b*sqrt(r) and returns b,r (be can be 1 or a product of several expressions) #
_radsimp_matchmultsqrt := proc(e) 
local r,t,f,b;
begin
   if type(e)="_mult" then
      b:=1; r:=1;
      for t in e do
         if (f:=_radsimp_matchsqrt(t))<>FAIL then r:=r*f else b:=b*t end_if
      end_for;
      if r<>1 then return(b,r) end_if
   elif (r:=_radsimp_matchsqrt(e))<>FAIL then return(1,r)
   elif type(e)="_power" then
      if type(op(e,2))=DOM_RAT and type(2*op(e,2))=DOM_INT then
         return(op(e,1)^(op(e,2)-1/2),op(e,1))
      end_if
   end_if;
   FAIL
end_proc:

_radsimp_sqrtdepth := proc(e)
local i;
option remember;
begin
   if _radsimp_matchsqrt(e)<>FAIL then 1+_radsimp_sqrtdepth(op(e,1))
   elif type(e)="_power" then
      if type(op(e,2))=DOM_RAT and type(2*op(e,2))=DOM_INT then 1+_radsimp_sqrtdepth(op(e,1))
      else 0
      end_if
   elif contains({"_plus","_mult"},type(e)) then max(_radsimp_sqrtdepth(op(e,i))$i=1..nops(e))
   else 0
   end_if
end_proc:

