# $Date: 1995/07/17 11:27:15 $ $Author: kg $ $Revision: 1.11.2.1 $ #

# kg, 19/01/94 #

#++
normal -- normal form of a rational expression

normal(x)

x - expression

The normal form of x is numer(x)/denom(x), where the numerator and
denominator are expanded polynomial expressions with gcd 1.
++#

normal:= func_env(
proc(x)
begin
    if args(0) <> 1 then error("wrong no of args") end_if;
    if x::normal <> FAIL then return(x::normal(x)) end_if;
    if contains({DOM_LIST, DOM_SET, DOM_ARRAY, DOM_TABLE}, domtype(x)) then
	return(map(x, normal))
    end_if;

    x:= stdlib::normal(x);
    x[1] / x[2]
end_proc,
NIL,
table("print" = "normal",
      "info" = "normal(x) -- normalizes expression x")
):



#--
stdlib::normal -- normal form of a rational expression

stdlib::normal(x)

x - expression

The normal form of x is numer(x)/denom(x), where the numerator and
denominator are expanded polynomial expressions. stdlib::normal
returns the list [numer(x), denom(x)].
--#

stdlib::normal:= proc(x)
    local ex2ind, r, n, d, f, fn, fd;
    option remember;
begin
    ex2ind:= table();

    r:= stdlib::rnormal(x);
    if nops(r[3]) = 0 then
	return([r[1], r[2]])
    end_if;
    f:= [ op(r[3]) ];
    n:= poly(r[1], f);
    d:= poly(r[2], f);

    if iszero(n) then return([ 0, 1 ]) end_if;

    # make polynomials primitive #
    fn:= icontent(n);
    fd:= icontent(d);
    if lcoeff(d) < 0 then fn:= -fn; fd:= -fd end_if;
    f:= fn/fd;
    if domtype(f) = DOM_INT then
	n:= expr(multcoeffs(n, f/fn));
	d:= expr(multcoeffs(d, 1/fd));
    else
	n:= expr(multcoeffs(n, op(f,1)/fn));
	d:= expr(multcoeffs(d, op(f,2)/fd));
    end_if;

    # un-freeze non-rational subexpressions #
    if nops(r[4]) = 0 then
	[ n, d ]
    else
    	f:= op(r[4]);
    	n:= subs(n, f);
    	d:= subs(d, f);
    	r:= n/d;
    	if x <> r then stdlib::normal(r) else [ n, d ] end_if
    end_if
end_proc:


#--
stdlib::rnormal -- normal form of a rational expression

stdlib::rnormal(x)

x   - expression

stdlib::rnormal returns a list [n,d,u,s] where n is the numerator,
d the denominator of x, u the set of unknowns of u and d and s is
a list of substitutions for non-rational subexpressions.
--#

stdlib::rnormal:= proc(x)
    local y, d, g, u, ind, S;
    option remember;
    name normal;
begin
    case type(x)
    of DOM_IDENT do
	return([ x, 1, {x}, {} ]);

    of DOM_INT do
	return([ x, 1, {}, {} ]);

    of DOM_RAT do
	return([ op(x,1), op(x,2), {}, {} ]);

    of "_plus" do
	d:= nops(x);
	g:= d div 2;
	y:= stdlib::rnormal(_plus(op(x, 1..g)));
	x:= stdlib::rnormal(_plus(op(x, (g+1)..d)));
	u:= x[3] union y[3];
	S:= x[4] union y[4];

	if nops(x[3] intersect y[3]) = 0 then
	    return([ x[1]*y[2] + y[1]*x[2], x[2]*y[2], u, S ])
	end_if;

	if domtype(x[2]) = DOM_INT then
	    if domtype(y[2]) = DOM_INT then
		return([ x[1]*y[2] + y[1]*x[2], x[2]*y[2], u, S ])
	    end_if
	end_if;

	ind:= [ op(u) ];
	x[1]:= poly(x[1], ind);
	x[2]:= poly(x[2], ind);
	y[1]:= poly(y[1], ind);
	y[2]:= poly(y[2], ind);

	g:= gcd(x[2], y[2]);
	d:= divide(x[2], g, Exact);
	x:= x[1] * divide(y[2], g, Exact) + y[1] * d;
	y:= y[2] * d;
	g:= gcd(x, y);
	return([ expr(divide(x, g, Exact)), expr(divide(y, g, Exact)), u, S ]);

    of "_mult" do
	d:= nops(x);
	g:= d div 2;
	y:= stdlib::rnormal(_mult(op(x, 1..g)));
	x:= stdlib::rnormal(_mult(op(x, (g+1)..d)));
	u:= x[3] union y[3];
	S:= x[4] union y[4];

	if nops(x[3] intersect y[3]) = 0 then
	    return([ x[1]*y[1], x[2]*y[2], u, S ])
	end_if;

	if domtype(x[2]) = DOM_INT then
	    if domtype(y[2]) = DOM_INT then
		return([ x[1]*y[1], x[2]*y[2], u, S ])
	    end_if
	end_if;

	ind:= [ op(u) ];
	x[1]:= poly(x[1], ind);
	x[2]:= poly(x[2], ind);
	y[1]:= poly(y[1], ind);
	y[2]:= poly(y[2], ind);

	g:= gcd(x[1], y[2]);
	d:= gcd(y[1], x[2]);
	return([ expr(divide(x[1], g, Exact) * divide(y[1], d, Exact)),
		 expr(divide(x[2], d, Exact) * divide(y[2], g, Exact)), u, S ]);

    of "_power" do
	d:= op(x,2);
	if domtype(d) = DOM_INT then
	    g:= stdlib::rnormal(op(x,1));
	    if d > 0 then
		return([ g[1]^d, g[2]^d, g[3], g[4] ])
	    end_if;
	    d:= -d;
	    return([ g[2]^d, g[1]^d, g[3], g[4] ]);
	end_if;

        case type(d)
        of DOM_RAT do
        of DOM_FLOAT do
            if d < 0 then
                g:= stdlib::rnormal(op(x,1)^(-d));
                return([ g[2], g[1], g[3], g[4] ])
            end_if;
            break;
        of "_plus" do
            d:= expand(x);
            if d <> x then
                return(stdlib::rnormal(d))
            end_if;
            break;
        of "_mult" do
            if op(d, nops(d)) = -1 then
                g:= stdlib::rnormal(op(x,1)^(-d));
                return([ g[2], g[1], g[3], g[4] ])
            end_if;
            d:= expand(x);
            if d <> x then
                return(stdlib::rnormal(d))
            end_if;
        end_case;
        break;

    of DOM_COMPLEX do
	u:= stdlib::normal_newind(I);
	x:= stdlib::rnormal(op(x,1) + u*op(x,2));
	return([ x[1], x[2], x[3], x[4] union {u=I} ]);

    of "_and" do
    of "_or" do
    of "_not" do
    of "_minus" do
    of "_intersect" do
    of "_union" do
        error("not an arithmetical expression");
        
    otherwise
        if x::normal <> FAIL then
	    x:= x::normal(x);
            u:= stdlib::normal_newind(x);
            return([ u, 1, {u}, {u=x} ]);
        end_if;
    end_case;

    if domtype(x) = DOM_EXPR then
        d:= op(x,0);
        x:= map(x, normal);
        if op(x,0) <> d then return(stdlib::rnormal(x)) end_if;
    end_if;
    u:= stdlib::normal_newind(x);
    [ u, 1, {u}, {u=x} ]
end_proc:


#--
stdlib::normal_newind -- create new ident for non-rational expression

stdlib::normal_newind(x)

x - non-rational expression

Returns an ident which replaces x. The new ident and x are inserted
into ex2ind !
--#

stdlib::normal_newind:= proc(x)
    local y;
begin
    if contains(ex2ind, x) then
	ex2ind[x]
    else
	y:= genident("_normal_");
	ex2ind[x]:= y;
	y
    end_if
end_proc:

# end of file #
