# $Date: 1995/04/12 08:58:31 $ $Author: kg $ $Revision: 1.1 $ #

# kg, 12/04/95 #

#++
maprec -- recursively maps operands of expression

maprec(e [, q=f...] [, PreMap] [, PostMap])

e       - expression to map
q       - qualifier (set of types or predicate function)
f       - matching function
PreMap  - option
PostMap - option

maprec recursively maps matching subexpressions of e. For each subexpression
s of e it is tested wether one of the matching equations apply. The first
matching equation defines the new value f(s) of the subexpression, which is
inserted into e instead of s. If no matching equation applies then s is not
altered.

Qualifiers used in matching equations may have one of two forms:

- {t1,...,tn} matches any subexpression s of type t1,...,tn.

- A predicate function p matches any subexpression s for which p(s) returns
  TRUE (p must return a boolean value).

If the option PreMap is given, then for each subexpression s of e first the
operands of s are mapped recursively; only after mapping the operands it ist
tested wether a matching equations applies for the result.

If the option PostMap is given, then for each subexpression s of e it is
tested wether any of the matching equations applies. If no match
applies then the operands of s are mapped recursively.

Both options may be given. If no option is given then only PreMap is used.

Important notes:

- Only operands of expressions (i.e. DOM_EXPRs), sets, lists, arrays and
  tables are mapped recusively. Operands of other types are not mapped in
  order to avoid unwanted substitutions. If one wants to map the operands of
  other types of subexpressions one has to do that explicitly by adding
  matching equations, like for example {DOM_PROC}=handle_procs.

- The operators of expressions (op 0) are also mapped recursively like the
  other operands.

One may overload maprec: If the domain of a subexpression has the method
"maprec" then that method is called with the subexpression and the other
arguments of the call. The result replaces the subexpression (no pre- or
post-mapping of operands is applied).

If one wants to stop the mapping then one should call breakmap(). After
calling this no further mappings are applied.
++#

maprec:= proc(ex)
    local n, i, bm, pre, post, mapeq;
begin
    n:= args(0);
    case n
    of 0 do error("no args");
    of 1 do return(ex);
    end_case;
    
    mapeq:= [args(2..args(0))];
    pre:= contains(mapeq, hold(PreMap));
    if pre = 0 then pre:= FALSE else mapeq[pre]:= NIL; pre:= TRUE end_if;
    post:= contains(mapeq, hold(PostMap));
    if post = 0 then post:= FALSE else mapeq[post]:= NIL; post:= TRUE end_if;
    if not pre and not post then pre:= TRUE end_if;

    if mapeq = [] then return(ex) end_if;

    if testargs() then
	if {op(map(mapeq, type))} <> {"_equal"} then
	    error("illegal equation")
	end_if
    end_if;
    
    bm:= stdlib::do_breakmap;
    stdlib::do_breakmap:= FALSE;
    ex:= stdlib::maprec(ex, mapeq, pre, post);
    stdlib::do_breakmap:= bm;
    ex
end_proc:

# stdlib::maprec does maprec work #
stdlib::maprec:= proc(ex, mapeq, pre, post)
    local f, t;
begin
    if stdlib::do_breakmap then return(ex) end_if;
    t:= domtype(ex);
    
    if t::maprec <> FAIL then 
        return(t::maprec(ex, op(mapeq),
        		(if pre then hold(PreMap) else null() end_if),
        		(if post then hold(PostMap) else null() end_if)))
    end_if;

    if pre then
        if contains(stdlib::DomainsMapOp, t) then
	    if t = DOM_EXPR then
		ex:= stdlib::maprec(op(ex,0), mapeq, pre, post)(
			op(map([op(ex)], stdlib::maprec, mapeq, pre, post)))
            else
		ex:= map(ex, stdlib::maprec, mapeq, pre, post)
            end_if;
            if stdlib::do_breakmap then return(ex) end_if
        end_if
    end_if;

    for eq in mapeq do
        if domtype(op(eq,1)) = DOM_SET then
            if contains(op(eq,1), type(ex)) then
                return(op(eq,2)(ex));
            end_if
        elif op(eq,1)(ex) = TRUE then
            return(op(eq,2)(ex))
        end_if;
    end_for;
    
    if post then
        t:= domtype(ex);
        if contains(stdlib::DomainsMapOp, t) then
	    if t = DOM_EXPR then
		ex:= stdlib::maprec(op(ex,0), mapeq, pre, post)(
			op(map([op(ex)], stdlib::maprec, mapeq, pre, post)))
            else
		ex:= map(ex, stdlib::maprec, mapeq, pre, post)
            end_if
        end_if
    end_if;
    ex
end_proc:

# domain types which map their operands #
stdlib::DomainsMapOp:= {
    DOM_ARRAY, DOM_SET, DOM_LIST, DOM_TABLE, DOM_EXPR
}:


#++
breakmap -- stop mapping with maprec

breakmap()

-no args-
++#

breakmap:= fun((
    if args(0) <> 0 then error("no args allowed") end_if;
    stdlib::do_breakmap:= TRUE
)):

# end of file #
