# $Date: 1994/08/01 10:54:16 $ $Author: kg $ $Revision: 1.2 $ #

# kg, 22/12/93 #

#++
lcm -- compute the lcm of polynomials or expressions

lcm(poly,...)
lcm(expr,...)

poly - polynomials
expr - polynomial expressions

lcm computes the lcm of polynomials or expressions.
++#

lcm:= proc()
    local j, l, g;
begin
    if args(0) = 0 then error("wrong no of args") end_if;

    # try to overload #
    for g in [ args() ] do
	if g::lcm <> FAIL then return(g::lcm(args())) end_if;
    end_for;

    if args(0) = 1 then return(gcd(args(1))) end_if;

    l:= args(1);
    for j from 2 to args(0) do
	g:= gcd(l, args(j));
	if g = FAIL then return(FAIL) end_if;
	if iszero(g) then return(g) end_if;
	case domtype(g)
	of DOM_POLY do
	    l:= divide(l*args(j), g, Exact);
	    break;
	of DOM_INT do
	of DOM_RAT do
	    l:= expand((l*args(j))/g);
	    break;
	otherwise
	    l:= divide(l*args(j), g, Exact);
	end_case
    end_for;
    l
end_proc:

# end of file #
