# $Date: 1995/03/21 14:54:21 $ $Author: kg $ $Revision: 1.14 $ #

# kg, 09/12/93 #

#++
gcd -- compute the gcd of polynomials or expressions

gcd(poly,...)
gcd(expr,...)

poly - polynomials
expr - polynomial expressions

gcd computes the gcd of polynomials or expressions.
++#

gcd:= proc()
    local a, t, x, i, g, f, conv, normp, gcdp;
begin
    if args(0) = 0 then error("wrong no of args") end_if;

    # try to overload #
    a:= [ args() ];
    for t in a do
	if t::gcd <> FAIL then return(t::gcd(args())) end_if;
    end_for;

    # convert args to polys #
    t:= { op(map(a, domtype)) };

    if contains(t, DOM_POLY) then
	if testargs() then
	    if nops(t) <> 1 then
		error("not a polynomial")
	    end_if;
	    if nops({op(map(a, op, 2..3))}) <> 2 then
		error("argument types differ")
	    end_if;
	end_if;
	conv:= id;
    else
	# only integer or rational args? #
	case gcdlib::min_domain(t)
	of DOM_EXPR do
	    break;
	of DOM_INT do
	    if args(0) = 1 then return(args(1)) end_if;
	    return(igcd(args()));
	otherwise
	    return(1);
	end_case;

	# convert expr to polys #
	a:= gcdlib::expr2polys([args()]);
	if a = FAIL then
	    error("not a rational polynomial")
	end_if;
	conv:= expr;
    end_if;

    # now a is a list of polynomials, remove zero polynomials 
      and get their type #
    g:= a[1];
    a:= select(a, not iszero);
    if a = [] then return(conv(g)) end_if;
    x:= op(g, 2);
    t:= op(g, 3);

    if testargs() then
	if domtype(t) = DOM_DOMAIN then
	    # need gcd method for coeffs #
	    if t::gcd = FAIL then error("method 'gcd' missing") end_if;
	    if t::divex = FAIL then error("method 'divex' missing") end_if
	elif t = Expr then
	    # can't handle real or complex coeffs #
	    case gcdlib::coeff_type(a)
	    of DOM_INT do
	    of DOM_RAT do
	        break;
	    otherwise
		error("illegal coefficients")
	    end_case
	else
	    # polynomial with coeffs from Zp must have prime modulus #
	    if not isprime(op(t,1)) then
		error("modulus must be prime")
	    end_if
	end_if;
    end_if;

    # sort according to ascending degrees #
    if nops(a) > 2 then
	a:= sort(a, fun(bool(degree(args(1)) < degree(args(2)))))
    end_if;

    if domtype(t) = DOM_DOMAIN then
	gcdp:= gcdlib::dom_gcd;
	normp:= gcdlib::norm_domp;
    elif t = Expr then
	# polynomial with expressions as coeffs #
	case gcdlib::coeff_type(a)
	of DOM_INT do
	    gcdp:= gcdlib::int_gcd;
	    normp:= gcdlib::norm_intp;
	    break;

	of DOM_RAT do
	    gcdp:= gcdlib::int_gcd;
	    normp:= fun(args(1));
	    conv:= fun(multcoeffs(args(1), 1/lcoeff(args(1)))) @ conv;
	    a:= map(a, fun(multcoeffs(args(1), 1/icontent(args(1)))));
	    break;

	otherwise
	    # we try our best... #
	    if conv = expr then
		error("illegal coefficients")
	    end_if;
	    g:= gcd(op(map(a, expr)));
	    if g = FAIL then
		error("illegal coefficients")
	    end_if;
	    return(poly(g, x, t))
	end_case
    else
	# polynomial with coeffs from Zp #
	gcdp:= gcdlib::mod_gcd;
	normp:= gcdlib::norm_modp;
    end_if;
    
    if nops(a) = 1 then
	g:= normp(a[1])
    else
	g:= gcdlib::special_cases(a[2], a[1], gcdp, normp);
	for i from 3 to nops(a) do
	    g:= gcdlib::special_cases(a[i], g, gcdp, normp);
	end_for
    end_if;
    conv(g)
end_proc:

# end of file #
