# $Date: 1995/06/28 14:42:59 $  $Author: kg $  $Revision: 1.6.2.2 $ #
# kg, 11.05.93 #

#++
export -- export interface names of a library domain into global name space

export(lib, [ name_1,...,name_n ] )

lib               - library domain
name_1,...,name_2 - names to export

export is a convenience function to export function names of library domains.
If 'lib' is a library domain and 'lib::func' is a function of that library,
the function may be called via 'lib::func(...)'.

Often one wishes simply to call 'func(...)'. If the name 'func' is contained
in the set 'lib::interface' of library interface names, it may be exported
into the global name space via 'export(lib,func);'. After the name is exported,
one may call 'func(...)' directly.

More than one name may be exported at a time. If no name is given, all the
names in the set 'lib::interface' are exported.

If a name to be exported already has a value, the value is not redefined and
a warning is printed.
++#

proc()
    local D;
begin

export:= proc(dom)
    local i, __name__, str, PRETTY_PRINT;
begin
    if args(0) < 1 then error("no args") end_if;
    if domtype(dom) <> DOM_DOMAIN then error("not a domain") end_if;
    if dom::exported = FAIL then dom::exported:= {} end_if;
    PRETTY_PRINT:= FALSE;

    if args(0) = 1 then
        for __name__ in dom::interface do
	    if domtype(__name__) <> DOM_IDENT then
		error("in interface: name must be identifier")
	    end_if;
	    str:= "".__name__;
	    if eval(subsop(hold(val(x)),1=__name__)) = __name__ then
		hold(new(stdlib::EvalExported, __name__, dom, str));
		eval(subsop(hold((i:=i)), 1=__name__, 2=%));
		dom::exported:= dom::exported union { __name__ };
	    elif contains(dom::exported, __name__) then
		print(Unquoted,
		      "Warning: '".str."' already is exported") 
	    else
		print(Unquoted,
		      "Warning: '".str."' already has a value, not exported")
	    end_if
	end_for
    else
	for i from 2 to args(0) do
	    __name__:= args(i);
	    if domtype(__name__) <> DOM_IDENT then
		error("global name must be identifier")
	    end_if;
	    str:= "".__name__;
	    if contains(dom::interface, __name__) then
		if eval(subsop(hold(val(x)),1=__name__)) = __name__ then
		    hold(new(stdlib::EvalExported, __name__, dom, str));
		    eval(subsop(hold((i:=i)), 1=__name__, 2=%));
		    dom::exported:= dom::exported union { __name__ };
		elif contains(dom::exported, __name__) then
		    print(Unquoted,
			  "Warning: '".str."' already is exported") 
                else 
                    print(Unquoted,
			  "Warning: '".str."' already has a value, not exported") 
                end_if
	    else
	    	error("unknown interface name")
	    end_if
	end_for
    end_if;
    null()
end_proc:

#
stdlib::EvalExported -- domain to evaluate exported name to domain entry

An element of this domain is assigned to each exported name. When the
domain element is evaluated it assigns the domain entry which contains the
value to be exported to the exported name.

We can't assign the domain entry to be exported to the name directly 
because that would cause the loading of those entries from file which
are defined via 'loadproc'.

An element has operands
1- name of exported function
2- domain from which to export function
3- index of domain entry
#

D:=  domain():
D::name:= "stdlib::EvalExported":

D::new:= proc() begin
    new(stdlib::EvalExported, args())
end_proc:

D::evaluate:= proc()
begin
    eval(subsop(hold((i:=i)), 1=extop(args(1),1),
			      2=domattr(extop(args(1),2), extop(args(1),3))));
    context(extop(args(1),1))
end_proc:

D::posteval:= D::evaluate:

D::func_call:= proc()
begin
    eval(subsop(hold((i:=i)), 1=extop(args(1),1),
			      2=domattr(extop(args(1),2), extop(args(1),3))));
    context(extop(args(1),1)(args(i) $ hold(i)=2..args(0)))
end_proc:

D::set_func_call:= proc()
begin
    eval(subsop(hold((i:=i)), 1=extop(args(1),1),
			      2=domattr(extop(args(1),2), extop(args(1),3))));
    eval(subsop(hold((f(a):=v)), [1,0]=extop(args(1),1),
        [1,1]=(args(i) $ hold(i)=2..args(0)-1), 2=args(args(0))));
    context(extop(args(1),1))
end_proc:

stdlib::EvalExported:= D:
null():
end_proc():

# end of file #
