# $Date: 1995/02/22 12:38:02 $  $Author: kamo $  $Revision: 1.2 $ #

#*******************************************************#
# 'evalassign'                                          #
#                                                       #
# Aufruf: evalassign(left,right,depth);                 #
#                                                       #
# Prozedur realisiert eine Zuweisung die vor der        #
# Ausfuehrung der eigentlichen Zuweisung, die linke     #
# Seite dieser 'depth' - Stufen evaluiert.              #
#                                                       #
# Argumente : 'left'  --  linke Seite der Zuweisung     #
#             'right' --  rechte Seite der Zuweisung    #
#             'depth' --  Evaluierungsstufe             #
#                                                       #
# Andreas Kemper (14/12/92)                             #
#*******************************************************#

evalassign := proc(left, right, depth)
    option hold;
begin
    if testargs() then
       if args(0) <> 3 then
	  error("Wrong number of arguments!");
       end_if;
    end_if;
    depth:= context(depth);
    if depth = 0 then
	context(subsop(hold(_assign(dummy, dummy)), 1=left, 2=right))
    else
	context(
	    subsop(hold(_assign(dummy, dummy)),
		   1=context(
		      subsop(hold(level(dummy, dummy)), 1=left, 2=depth)),
		   2=right))
    end_if
end_proc:

