
#
Ref: Polynomial Decomposition Algorithms, by David R. Barton and Richard Zippel,
JSC 1, 1985, pages 159-168
#

#
>> decompose(x^12+13*x^8+17*x^4+9);

                          2    3       2   2
               17 x + 13 x  + x  + 9, x , x 

>> decompose(x^6+6*x^4+x^3+9*x^2+3*x-5);

                                2             3
                           x + x  - 5, 3 x + x 

>> decompose( x^6-9*x^5+27*x^4-27*x^3-2*x^2*y+6*x*y+1, x );

                                  3                2
                       - 2 x y + x  + 1 , - 3 x + x 

>> decompose( x^4-3*x^3-x+5);
                                      FAIL

>> decompose(poly(x^4-3*x^3-x+5,[x],IntMod(5)));

         /        2                  \       /      2                 \
    poly \ - x + x  , [x], IntMod(5) /, poly \ x + x , [x], IntMod(5) /
#

# algorithm U page 166 : uses only univariate factorization #
decompose := proc(p,x)
local f,g,gt,i,l,a,k,j,m,r,n,l1;
begin
   # check arguments #
   if type(p)=DOM_POLY then f:=p else f:=poly(p) end_if;
   if args(0)=1 then
      if nops(op(f,2))<>1 then error("please specify variable") else x:=op(f,[2,1]) end_if
   elif args(0)=2 then
      if contains(op(f,2),x)=0 then error("variable not in polynomial") end_if;
      f:=subsop(f,2=[x]);
   else error("invalid arguments")
   end_if;
   n:=degree(f);
   if n=1 or isprime(n) then return(p) end_if;
   k:=[x],op(f,3); # coefficient field #
   # step U1: initialization #
   g[0]:=poly(x,k); gt[0]:=g[0];
   # step U2: factorization #
   a[0]:=g[0]; # a_0(x)=x #
   l:=divide(f-poly(coeff(f,0),k),g[0],Exact);
   l:=factor(l); l1:=l[1];
   userinfo(2,"factorization is",l);
   r:=0;
   for j from 1 to nops(l)/2 do
      for m from 1 to l[2*j+1] do a[r+m]:=l[2*j] end_for;
      r:=r+l[2*j+1];
   end_for;
   l:=stdlib::decomp_multiples_of(a,r,poly(1,k));
   userinfo(2,"list of possible candidates is",l);
   g:=stdlib::decomp(l,g,gt,1,n);
   if g=FAIL then return(p)
   else i:=nops(g)-1
   end_if;
   g[i]:=multcoeffs(g[i],l1)+poly(f(0),k);
   if domtype(p)=DOM_EXPR then
      for j from 1 to i do g[j]:=expr(g[j]) end_for
   end_if;
   g[i-j]$hold(j)=0..i-1
end_proc:

stdlib::decomp := proc(l,g,gt,i,n) local ll,j,q;
begin
      # step U3: find candidate #
      ll:=[];
      for j in l do
         if (q:=divide(j,gt[i-1],Exact))<>FAIL then
            if degree(q)>0 then ll:=append(ll,j) end_if
         end_if
      end_for;
      ll:=sort(ll,fun(bool(degree(args(1))<degree(args(2)))));
      userinfo(2,"list of possible candidates is",ll);
      for q in ll do
         # step U4: p-adic expansion #
         gt[i]:=q;
         userinfo(2,"gt[".i."]=",gt[i]);
         # here there was a typo in the paper: we have to
           divide gt[i] by gt[i-1] and not g[i-1] #
         g[i]:=stdlib::decomp_compute_g(gt[i],gt[i-1]);
         userinfo(2,"find divisor g[".i."]:",g[i]);
         if g[i]<>FAIL then # try to recurse #
            if degree(gt[i])=n then return(g)
            else q:=stdlib::decomp(ll,g,gt,i+1,n)
            end_if;
            if q<>FAIL then return(q) end_if
         end_if;
      end_for;
      FAIL
end_proc:

# compute g such that f(x)=g(h(x)) using the algorithm of section 2.1 #
stdlib::decomp_compute_g := proc(f,h)
local q,i,x,j;
begin
   x:=op(h,[2,1]); if op(h,1)=x then return(f) end_if;
   i:=0; q[0]:=f; 
   repeat
      q[i+1]:=divide(q[i]-subsop(q[i],1=q[i](0)),h,Exact);
      i:=i+1;
      if q[i]=FAIL then return(FAIL) end_if;
   until degree(q[i])=0 end_repeat;
   subsop(h,1=_plus(q[j](0)*x^j$j=0..i))
end_proc:

# find all the products of a[j], 0<=j<=r #
# p is an auxiliary product, initially 1 #
stdlib::decomp_multiples_of := proc(a,r,p)
begin
   if r=-1 then {p}
   else
      stdlib::decomp_multiples_of(a,r-1,p) union 
      stdlib::decomp_multiples_of(a,r-1,p*a[r])
   end_if
end_proc:

