# #
# $Date: 1995/05/26 13:19:19 $ $Author: zimmerma $ $Revision: 1.10 $ #

# frankp, 15.02.1995 #

#++
   combine.mu

	combine  --  combine terms of the same algebraic structure

	combine(expr) combines terms of the same algebraic
	structure.
	This function combines not yet expressions which are not powers.

	For expressions of type DOM_FUNC_ENV the function attribute
	"combine" will be called with the operands of expr.
	If such a function attribute does not exist the expression will
	be returned without changes.
++#

combine := proc(e,p)
    local t, f, l, i, n, b;
begin
    case args(0)
    of 1 do break
    of 2 do if traperror((p:=funcattr(combine,expr2text(args(2)))))=0 then return(p(e))
	    else error("invalid second argument")
            end_if
    otherwise error("wrong no of args")
    end_case;

    # is overloaded ? #
    if e::combine <> FAIL then return( e::combine(e) ) end_if;

    case domtype(e) 
    # default is to return e, thus we do not need to consider these cases #
    of DOM_POLY	   do return( mapcoeffs(e,combine) )
    of Puiseux	   do return( map(e,combine) )
    of DOM_LIST    do 
    of DOM_ARRAY   do
    of DOM_SET     do return( map(e,combine) )
    of DOM_EXPR    do
        t := op(e,0);
        if domtype(level(t,2)) = DOM_FUNC_ENV then
	    if funcattr(level(t,2),"combine") <> FAIL then
                return( funcattr(level(t,2),"combine")(op(e)) )
            end_if
	end_if;
        if type(e)="_mult" then
	    f := fun((if type(args(1))="_power" then 
			 if op(args(1),1) = args(2) then TRUE else FALSE end_if
		      else FALSE
		      end_if)
		 );
	    p := 1;
	    e := {op(e)};
	    i := 1;
	    repeat
		t := op(e,i);
		if type(t) = "_power" then
		    b := op(t,1); n := op(t,2)
		else 
		    b := t; n := 1
		end_if;
		e := e minus {t};
		l := select(e, f, b);
		e := e minus l;
		for t in l do n := n + op(t,2) end_for;
		p := p*b^n;
	    until nops(e) = 0 end_repeat;
	    return( p )
	end_if;
	return( map(e,combine) )
    end_case;
    e
end_proc:

# sqrt(a)*sqrt(b) ==> sqrt(a*b) #
combine:=funcattr(combine,"sqrt",
proc(e) 
local t,a,f,g,matchsqrt;
begin
   matchsqrt := proc(e) # matches sqrt(f) and returns f, or FAIL #
   begin
      if type(e)="_power" then if op(e,2)=1/2 then return(op(e,1)) end_if
      elif type(e)="sqrt" then return(op(e))
      end_if;
      FAIL
   end_proc;

   case type(e)
   of "_mult" do
      f:=1; g:=1;
      for t in e do
         if (a:=matchsqrt(t))<>FAIL then f:=f*a else g:=g*t end_if
      end_for;
      return(f^(1/2)*g)
   of "_plus" do return(map(e,funcattr(combine,"sqrt")))
   otherwise e
   end_case;
end_proc):

# cos(x)^2 -> cos(2*x)/2+1/2 #
combine:=funcattr(combine,"sincos",proc(e)
local l,k,f;
begin
   case domtype(e) # default is to return e #
   of DOM_POLY	  do return( mapcoeffs(e,funcattr(combine,"sincos")) )
   of Puiseux	  do
   of DOM_LIST    do 
   of DOM_ARRAY   do
   of DOM_SET     do return( map(e,funcattr(combine,"sincos")) )
   of DOM_EXPR    do
      case type(e)
      of "_mult" do e:=[op(e)]; break
      of "_power" do e:=[e]; break
      otherwise return(map(e,funcattr(combine,"sincos")))
      end_case;
      # now deal with _mult and _power case #
      k:=1; l:=[];
      for f in e do
         case type(f)
         of "sin" do
         of "cos" do l:=append(l,f); break
         of "_power" do
            if contains({"sin","cos"},type(op(f,1))) and testtype(op(f,2),Type::PosInt) then
               l:=append(l,op(f,1)$op(f,2)); break
            end_if
         otherwise k:=k*map(f,funcattr(combine,"sincos"))
         end_case;
      end_for;
      return(_combine_sin_cos(l,maprat(k,normal)))
   end_case;
   e
end_proc):

# k is a scalar, l is a list of sin or cos expressions #
_combine_sin_cos := proc(l,k)
begin
   if l=[] then return(k) end_if;
   while nops(l)>=2 do
      if type(l[1])="_plus" then
         l[1]:=map(l[1],_combine_sincos,l[2])
      else l[1]:=_combine_sincos(l[1],l[2])
      end_if;
      l[2]:=NIL;
   end_while;
   if type(l[1])="_plus" then map(l[1],_mult,k) else k*l[1] end_if
end_proc:

# for x*y where x and y can be cos(..) or a*cos(..) or a where a is a rational #
_combine_sincos := proc(x,y) local a,b,m;
begin
   if type(x)="_mult" then m:=op(x,2); x:=op(x,1) else m:=1 end_if;
   if type(y)="_mult" then m:=m*op(y,2); y:=op(y,1) end_if;
   a:=op(x); b:=op(y);
   case type(x),type(y)
   of "sin","sin" do m/2*cos(a-b)-m/2*cos(a+b); break
   of "sin","cos" do m/2*sin(a+b)+m/2*sin(a-b); break
   of "cos","sin" do m/2*sin(a+b)-m/2*sin(a-b); break
   of "cos","cos" do m/2*cos(a-b)+m/2*cos(a+b); break
   otherwise m*x*y # it can happen that x or y is a constant, 
			for example cos(0) -> 1 for cos(t)^3 #
   end_case
end_proc:

# atan(x)+atan(y) = atan((x+y)/(1-x*y)) #
combine:=funcattr(combine,"atan",proc(e)
local s,f,x,y,i;
begin
   case domtype(e) # default is to return e #
   of DOM_POLY	  do return( mapcoeffs(e,funcattr(combine,"atan")) )
   of Puiseux	  do
   of DOM_LIST    do 
   of DOM_ARRAY   do
   of DOM_SET     do return( map(e,funcattr(combine,"atan")) )
   of DOM_EXPR    do
      case type(e)
      of "_plus" do
         s:=0; x:=0;
         for f in e do
            if type(f)="atan" then
               y:=op(f);
               x:=(x+y)/(1-x*y)
            elif type(f)="_mult" then # n*atan(y) #
               if nops(f)=2 and type(op(f,1))="atan" and type((i:=op(f,2)))=DOM_INT then
                  if i>0 then y:=op(op(f,1)) else y:=-op(op(f,1)); i:=-i end_if;
                  while i>0 do x:=(x+y)/(1-x*y); i:=i-1 end_while
               else s:=s+f
               end_if
            else s:=s+f
            end_if
         end_for;
         return(s+atan(x))
      otherwise return(map(e,funcattr(combine,"atan")))
      end_case
   end_case;
   e
end_proc):

# end of file #
