# #
# $Date: 1995/06/02 17:29:00 $ $Author: frankp $ $Revision: 1.3 $ #
# #
# frankp, 15.03.1995 #

#++
	asympt  --  computing asymptotic expansions

        asympt(ex,x [=v] [,ord])

        ex : expression in x
        x  : ident
	v  : (optional) expression
	ord: (optional) positive integer

        Compute the asymptotic series of ex of order ord with respect
	to at v. If v is missing then x is assumed to goes to infinity.
	If ord is missing then the value of ORDER is used (6 by default).

	If an expansion could not be computed, then the expression
	ex will be returned.
	Otherwise an element of the domain 'gseries' (defined in
	the library "Series") is returned, that can be manipulated 
	with the standard arithmetic operations.

	See ../SERIES/gseries.mu for detailed informations.
++#

loadlib("Series"):
asympt := proc(ex,x)
begin
    if args(0) < 2 or args(0) > 3 then
	error("wrong no of args")
    end_if;
    if args(0) = 2 and domtype(args(2)) = DOM_IDENT then
	gseries::new(ex,x=infinity)
    elif args(0) = 3 and domtype(args(2)) = DOM_IDENT then
	gseries::new(ex,x=infinity,args(3))
    else
	gseries::new(args())
    end_if
end_proc:

# end of file #
