# $Date: 1995/06/28 08:59:35 $  $Author: kg $  $Revision: 1.4.2.2 $ #

#--
TeX.mu - TeX-output of expressions

Some of the functions implemented here look quite obscure. The reason is that
TeX may call DOM_EXPR::TeX which in turn calls 'level'. In order to avoid
naming conflicts of actual parameters with formal parameters or local
variables due to this call of 'level' I use formal parameters or local
variables only if neccesary and name them obscure (like _0_s for expample).

This problem should become obselete in later versions of MuPAD either when
static scoping is implemented or when operators are represented by function
environments (rather than by identifiers which have to be evaluated to get
the corresponding function environments).
--#

proc() begin

#++
TeX -- return TeX-formatted string for expression

TeX(e,...)

e - expression
++#

TeX:= fun(level((
    case args(0)
    of 0 do
    	""; break;
    of 1 do
    	stdlib::TeX(args(1),0); break;
    otherwise
    	_concat(stdlib::TeX(args(1),20),
    		(",", stdlib::TeX(args(i),20)) $ hold(i)=2..args(0));
    end_case), 1));

#++
TeXdef -- define TeX-string for expression

TeXdef(e, s)

e - expression
s - TeX-string
++#

TeXdef:= fun((
    if args(0) <> 2 then error("wrong no of args") end_if;
    if domtype(args(2)) <> DOM_STRING then error("no TeX string") end_if;
    stdlib::TeXdefs[args(1)]:= args(2)
));

# ------------------------ internas ----------------------- #

# table of user-defined TeX-strings #

stdlib::TeXdefs:= table(hold(PI)="\\pi", hold(E)="e", I="i",
    op(map([

hold(Delta), hold(Phi), hold(Gamma), hold(Lambda), hold(Pi), hold(Theta),
hold(Sigma), hold(Upsilon), hold(Omega), hold(Xi), hold(Psi), hold(alpha),
hold(beta), hold(chi), hold(delta), hold(epsilon), hold(varepsilon),
hold(phi), hold(varphi), hold(gamma), hold(eta), hold(iota), hold(kappa),
hold(lambda), hold(mu), hold(nu), hold(pi), hold(varpi), hold(theta),
hold(vartheta), hold(rho), hold(varrho), hold(sigma), hold(varsigma),
hold(tau), hold(upsilon), hold(omega), hold(xi), hold(psi), hold(zeta),
hold(partial), hold(aleph), hold(Im), hold(Re), hold(wp)

    ], fun(args(1)="\\".args(1))))
    ):

#--
stdlib::TeX -- return TeX-formatted string for expression

stdlib::TeX(e,p)

e - expression
p - priority of enclosing expression
--#

stdlib::TeX:= fun((
    if contains(stdlib::TeXdefs, args(1)) then
	stdlib::TeXdefs[args(1)]
    else
	domattr(domtype(args(1)), "TeX")(args())
    end_if;
));

#--
stdlib::TeXquote -- quote TeX-string

stdlib::TeXquote(s,ep,sp)

s - TeX string
ep - priority of enclosing expression
sp - priority of this expression
--#

stdlib::TeXquote:= fun((
    if args(2) < args(3) then args(1) else "\\left(".args(1)."\\right)" end_if));

#--
stdlib::TeXseq -- create TeX string for sequence

stdlib::TeXseq(lb,rb,e,...)

lb, rb - strings with left and right brackets
e      - expression
--#

stdlib::TeXseq:= fun(_concat(
    args(1),
    (case args(0)
     of 2 do ""; break;
     of 3 do stdlib::TeX(args(3), 0); break;
     otherwise
     	stdlib::TeX(args(3), 20),
     	((",", stdlib::TeX(args(i), 20)) $ hold(i)=4..args(0));
     end_case),
    args(2)));

#--
stdlib::TeXoperator -- TeX formatting of operator

stdlib::TeXoperator(sym, ep, tp, op,...)

sym - operator symbol
ep  - priority of enclosing expression
tp  - priority of this expression
op  - operands
--#

stdlib::TeXoperator:= fun((
    case args(0)
    of 3 do ""; break;
    of 4 do stdlib::TeX(args(4), args(2)); break;
    otherwise
    	stdlib::TeXquote(
    	    _concat(stdlib::TeX(args(4), args(3)),
    	    	    (args(1), stdlib::TeX(args(i), args(3)))
    	    	     $ hold(i)=5..args(0)),
	    args(2), args(3))
    end_case
));

#--
stdlib::TeXfun -- TeX formatting function calls

stdlib::TeXfun(o,p,e,...)

o - TeX string of operator
p - priority of enclosing expression
e - operand expressions
--#

stdlib::TeXfun:= fun(
    args(1).stdlib::TeXseq("\\left(", "\\right)", args(i) $ hold(i)=3..args(0))
);

# uncomment the following procedure if you prefer f(x) to be
  formatted as 'f x' instead of 'f(x)'... #
#
stdlib::TeXfun:= proc() local _0_s; begin
    case args(0)
    of 2 do
    	args(1)."\\left(\\right)";
    	break;
    of 3 do
    	_0_s:= stdlib::TeX(args(3),140);
    	if substring(_0_s,0,7) = "\\left(" then
    	    args(1)._0_s
    	else
    	    stdlib::TeXquote(args(1)." "._0_s, args(2), 140)
    	end_if;
    	break;
    otherwise
    	args(1).stdlib::TeXseq("\\left(", "\\right)", args(i) $ hold(i)=3..args(0))
    end_case
end_proc;
#

# ------------- TeX formatting of domain elements ------------- #

DOM_INT::TeX:= fun(expr2text(args(1)));
DOM_RAT::TeX:= DOM_INT::TeX;
DOM_BOOL::TeX:= DOM_INT::TeX;
DOM_FAIL::TeX:= DOM_INT::TeX;
DOM_NIL::TeX:= DOM_INT::TeX;
DOM_NULL::TeX:= "";
DOM_SET::TeX:= fun(stdlib::TeXseq("\\left\\{", "\\right\\}", op(args(1))));
DOM_LIST::TeX:= fun(stdlib::TeXseq("\\left[", "\\right]", op(args(1))));
DOM_POLY::TeX:= fun(stdlib::TeX(expr(args(1)), args(2)));

DOM_COMPLEX::TeX:= fun(
    (if iszero(op(args(1),1)) then
     	stdlib::TeX(op(args(1),2),0)." i"
     else
	stdlib::TeXquote(
		stdlib::TeX(op(args(1),1),0)."+".stdlib::TeX(op(args(1),2),0)." i",
		args(2),120)
     end_if));
     
DOM_TABLE::TeX:= fun(_concat(
    "\\begin{eqnarray*}\n",
    (if nops(args(1)) = 0 then null() else
    	stdlib::TeX(op(args(1),[1,1]),60)," & = & ",
    	stdlib::TeX(op(args(1),[1,2]),60),"\\\\\n",
    	((stdlib::TeX(op(args(1),[i,1]),60)," & = & ",
    	  stdlib::TeX(op(args(1),[i,2]),60),"\\\\\n")
    	 $ hold(i)=2..nops(args(1)))
     end_if),
     "\\end{eqnarray}"));

DOM_ARRAY::TeX:= proc(_0_a) local _0_n, _0_m, _0_p; begin
    if op(_0_a,[0,1]) = 1 then
        _0_n:= op(_0_a,[0,2,1]);
        _0_m:= op(_0_a,[0,2,2]);
    	_concat(
    	    "\\begin{array}{", ("c" $ (_0_m - _0_n + 1)), "}\n",
    	    stdlib::TeX(_0_a[_0_n],20),
    	    ((" & ", stdlib::TeX(_0_a[i]),20) $ hold(i)=(_0_n+1).._0_m),
    	    "\n\\end{array}")
    elif op(_0_a,[0,1]) = 2 then
        _0_n:= op(_0_a,[0,3,1]);
        _0_m:= op(_0_a,[0,3,2]);
	_concat(
    	    "\\begin{array}{", ("c" $ (_0_m - _0_n + 1)), "}\n",
    	    ((stdlib::TeX(_0_a[j,_0_n],20),
    	      ((" & ", stdlib::TeX(_0_a[j,i],20))
    	      $ hold(i)=(_0_n+1).._0_m), "\\\\\n")
    	     $ hold(j)=op(_0_a,[0,2])),
    	    "\\end{array}")
    else
    	_0_p:= fun((
    	    if nops(args(1)) = op(_0_a,[0,1]) then
    	    	"(".stdlib::TeX(op(args(1)),60).") & = & ".
    	    	stdlib::TeX(_0_a[op(args(1))],60)."\\\\\n"
    	    else
    	    	_concat(_0_p(args(1).[i]) $ hold(i)=op(_0_a,[0,nops(args(1))+2]))
    	    end_if
    	));
    	"\\begin{eqnarray*}\n"._0_p([])."\\end{eqnarray}"
    end_if
end_proc;

DOM_FLOAT::TeX:= proc(x) local p, s; begin

    # p removes trailing zeros #
    p:= proc(s) local m; begin
	if strmatch(s, "\*.\*") then
    	    s:= text2list(s, ["."]);
    	    m:= s[3];
    	    while substring(m, strlen(m)-1, 1) = "0" do
    	        if strlen(m) = 1 then break end_if;
    	        m:= substring(m, 0, strlen(m)-1)
    	    end_while;
    	    s[1].".".m
	else
	    s
	end_if
    end_proc;
    
    x:= expr2text(x);
    if strmatch(x, "\*e\*") then
	x:= text2list(x, ["e"]);
	x[1]:= p(x[1]);
	stdlib::TeXquote(_concat(x[1]," 10^",
	    (if strlen(x[3]) = 1 then x[3] else "{".x[3]."}" end_if)),
	    args(2), 130)
    else
	p(x)
    end_if
end_proc;

DOM_STRING::TeX:= proc(x) begin
    # change _ into \_ #
    if strmatch(x, "\*_\*") then
	x:= _concat(op(subs(text2list(x, ["_"]), "_"="\\_")))
    end_if;
    "\\mbox{\"".x."\"}"
end_proc;

DOM_IDENT::TeX:= proc(x) begin
    # change _ into \_ #
    x:= expr2text(x);
    if strmatch(x, "\*_\*") then
	x:= _concat(op(subs(text2list(x, ["_"]), "_"="\\_")))
    end_if;
    if strlen(x) = 1 then x else "\\mbox{".x."}" end_if;
end_proc;

DOM_EXPR::TeX:= proc(_0_x) local _0_f; begin
    _0_f:= op(_0_x,0);
    if domtype(_0_f) = DOM_IDENT then
	_0_f:= level(_0_f);
    	if domtype(_0_f) = DOM_FUNC_ENV then
    	    if funcattr(_0_f, "TeX") = FAIL then
    	    	if domtype(op(_0_f,2)) = CAT_EXEC then
    	    	    stdlib::TeXfun("\\mbox{".op(_0_f,[2,4])."}", args(2), op(_0_x))
    	    	elif domtype(op(_0_f,1)) = CAT_EXEC then
    	    	    stdlib::TeXfun("\\mbox{".op(_0_f,[1,3])."}", args(2), op(_0_x))
    	    	else
    	    	    stdlib::TeXfun(stdlib::TeX(op(_0_x,0)), args(2), op(_0_x))
    	    	end_if
    	    else
    	    	funcattr(_0_f, "TeX")(_0_f, _0_x, args(2))
    	    end_if
	else
	    stdlib::TeXfun(stdlib::TeX(op(_0_x,0)), args(2), op(_0_x))
    	end_if
    else
    	stdlib::TeXfun(stdlib::TeX(_0_f,140), args(2), op(_0_x))
    end_if
end_proc;

DOM_DOMAIN::TeX:= fun((
    if (args(1))::name <> FAIL then
        if domtype((args(1))::name) = DOM_STRING then
            stdlib::TeX(text2expr((args(1))::name), args(2))
        else
	    stdlib::TeX((args(1))::name, args(2))
        end_if
    else
        stdlib::TeX(hold(domain)(), args(2))
    end_if
)):

# ------------------- TeX formatting of func-env's ------------------- #
#--
Each TeX-formatting routine must have the form
	myformatfunc(fenv, expr, prio)
where fenv is the func-env of this routine, expr is the original expression
causing this call (the operator of expr was evaluated to fenv) and prio is
the priority of the enclosing expression.

Be aware that one of the called functions stdlib::TeX... may call
DOM_EXPR::TeX which in turn calls 'level'! In order to avoid a naming
conflict one should use formal parameters or local variables only
if neccesary and name them obscure (libe _0_s for expample).
--#

_mult:= funcattr(_mult, "TeX", fun((
    	if testtype(op(args(2), nops(args(2))), NUMERIC) then
    	    if op(args(2), nops(args(2))) = -1 then
    	    	return("- ".funcattr(_mult,"TeX")(args(1),
    	    			subsop(args(2), nops(args(2))=null()), args(3)))
    	    end_if;
    	    return(funcattr(_mult,"TeX")(
    	    	    args(1), hold(_mult)(op(args(2), nops(args(2))),
    	    	    		op(args(2), 1..(nops(args(2))-1))), args(3)))
    	end_if;
    	stdlib::TeXoperator(" ", args(3), 130, op(args(2)))
    )));

_plus:= funcattr(_plus, "TeX",
    proc() local _0_s, _0_i, _0_o; begin
        case nops(args(2))
        of 0 do return("");
        of 1 do return(stdlib::TeX(op(args(2),1), args(3)));
        end_case;
        _0_s:= stdlib::TeX(op(args(2),1), 120);
        for _0_i from 2 to nops(args(2)) do
            _0_o:= op(args(2),_0_i);
            if testtype(_0_o, Type::RealNum) then
            	if _0_o < 0 then
            	    _0_s:= _0_s." ".stdlib::TeX(_0_o, 120); next
            	end_if
            elif type(_0_o) = "_mult" then
            	if testtype(op(_0_o,nops(_0_o)), Type::RealNum) then
            	    if op(_0_o,nops(_0_o)) < 0 then
            	    	_0_s:= _0_s." ".stdlib::TeX(_0_o, 120); next
            	    end_if
            	end_if
            end_if;
            _0_s:= _0_s." + ".stdlib::TeX(_0_o, 120)
        end_for;
        stdlib::TeXquote(_0_s, args(3), 120)
    end_proc);

_power:= funcattr(_power, "TeX",
    proc() local _0_s; begin
    	if testtype(op(args(2),2), Type::RealNum) then
    	    if op(args(2),2) = -1 then
    	        return("\\frac{1}{".stdlib::TeX(op(args(2),1),0)."}")
    	    end_if;
    	    if op(args(2),2) < 0 then
    	    	return("\\frac{1}{".
    	    	       funcattr(_power, "TeX")(_power,
    	    	       		op(args(2),1)^(-op(args(2),2)), 0)."}")
    	    end_if;
    	    if op(args(2),2) = 1/2 then
    	        return("\\sqrt{".stdlib::TeX(op(args(2),1),0)."}")
    	    end_if;
    	    if domtype(op(args(2),2)) = DOM_RAT then
    	        if op(args(2),[2,1]) = 1 then
		    return("\\sqrt[".expr2text(op(args(2),[2,2]))."]{".
		    	   stdlib::TeX(op(args(2),1),0)."}")
    	        else
		    return("\\sqrt[".expr2text(op(args(2),[2,2]))."]{".
		           funcattr(_power, "TeX")(_power,
		           	op(args(2),1)^op(args(2),[2,1]), 0)."}")
    	        end_if
    	    end_if
    	end_if;
    	_0_s:= stdlib::TeX(op(args(2),2),0);
    	if strlen(_0_s) <> 1 then _0_s:= "{"._0_s."}" end_if;
	stdlib::TeXquote(stdlib::TeX(op(args(2),1), 150)."^"._0_s, args(3), 150)
    end_proc);

diff:= funcattr(diff, "TeX",
    proc() local _0_l, _0_t, _0_x; begin
        _0_l:= [ op(args(2),2..nops(args(2))) ];
        _0_t:= table();
        for _0_x in _0_l do
            if contains(_0_t, _0_x) then
                _0_t[_0_x]:= _0_t[_0_x] + 1
            else
                _0_t[_0_x]:= 1
            end_if
        end_for;
        _0_t:= _concat(("d", TeX(op(_0_t,[i,1])^op(_0_t,[i,2])))
		       $ hold(i)=1..nops(_0_t));
        stdlib::TeXquote("\\frac{".TeX(hold(d)^nops(_0_l))."}{"._0_t."} ".
        		 stdlib::TeX(op(args(2),1), 135), args(3), 135)
    end_proc);

D:=  funcattr(D, "TeX", fun(
    stdlib::TeXquote(
    	(if nops(args(2)) = 1 then
    	     "D ".stdlib::TeX(op(args(2),1), 135)
    	 else
    	     TeX(hold(_index)(hold(D), op(op(args(2),1))))." ".
    	     stdlib::TeX(op(args(2),2), 135)
    	 end_if), args(3), 135)));

int:= funcattr(int, "TeX", fun(
    stdlib::TeXquote(
    	(if type(op(args(2),2)) = "_equal" then
    	    _concat("\\int_{", stdlib::TeX(op(args(2),[2,2,1]),0),
    	            "}^{", stdlib::TeX(op(args(2),[2,2,2]),0), "} ",
    	            stdlib::TeX(op(args(2),1),0),
    	            " d ", stdlib::TeX(op(args(2),[2,1]),140))
    	 else
    	    _concat("\\int ", stdlib::TeX(op(args(2),1),0),
    	            " d ", stdlib::TeX(op(args(2),2),140))
    	 end_if), args(3), 140)));
    	 
sum:= funcattr(sum, "TeX", fun(
    stdlib::TeXquote(
    	(if type(op(args(2),2)) = "_equal" then
    	    _concat("\\sum_{", stdlib::TeX(op(args(2),[2,1])=op(args(2),[2,2,1]),0),
    	            "}^{", stdlib::TeX(op(args(2),[2,2,2]),0), "} ",
    	            stdlib::TeX(op(args(2),1),125))
    	 else
    	    _concat("\\sum_{", stdlib::TeX(op(args(2),2),0), "} ",
    	    	    stdlib::TeX(op(args(2),1),125))
    	 end_if), args(3), 125)));

_index:= funcattr(_index, "TeX",
    proc() local _0_s; begin
    	_0_s:= stdlib::TeXseq("", "", op(args(2),i) $ hold(i)=2..nops(args(2)));
    	if strlen(_0_s) <> 1 then _0_s:= "{"._0_s."}" end_if;
    	stdlib::TeXquote(stdlib::TeX(op(args(2),1), 200)."_"._0_s, args(3), 200)
    end_proc);

_not:= funcattr(_not, "TeX",
    fun(stdlib::TeXquote("\\neg ".stdlib::TeX(op(args(2),1),180),
    			 args(3), 180)));

# remove comment if you prefer e^x instead of exp(x)...
exp:= funcattr(exp, "TeX",
    fun(funcattr(_power,"TeX")(exp, hold(_power)(hold(e), op(args(2),1)),
    			       args(3))));
#

_stmtseq:= funcattr(_stmtseq, "TeX",
    fun(stdlib::TeXoperator("; ", args(3), 10, op(args(2)))));
_exprseq:= funcattr(_exprseq, "TeX",
    fun(stdlib::TeXoperator(", ", args(3), 20, op(args(2)))));
_or:= funcattr(_or, "TeX",
    fun(stdlib::TeXoperator(" \\vee ", args(3), 30, op(args(2)))));
_and:= funcattr(_and, "TeX",
    fun(stdlib::TeXoperator(" \\wedge ", args(3), 40, op(args(2)))));
_less:= funcattr(_less, "TeX",
    fun(stdlib::TeXoperator(" < ", args(3), 60, op(args(2)))));
_leequal:= funcattr(_leequal, "TeX",
    fun(stdlib::TeXoperator(" \\leq ", args(3), 60, op(args(2)))));
_equal:= funcattr(_equal, "TeX",
    fun(stdlib::TeXoperator(" = ", args(3), 60, op(args(2)))));
_unequal:= funcattr(_unequal, "TeX",
    fun(stdlib::TeXoperator(" \\neq ", args(3), 60, op(args(2)))));
_range:= funcattr(_range, "TeX",
    fun(stdlib::TeXoperator(" \\ldots ", args(3), 70, op(args(2)))));
_mod:= funcattr(_mod, "TeX",
    fun(stdlib::TeXoperator(" \\mbox{mod} ", args(3), 80, op(args(2)))));
_div:= funcattr(_div, "TeX",
    fun(stdlib::TeXoperator(" \\mbox{div} ", args(3), 80, op(args(2)))));
_union:= funcattr(_union, "TeX",
    fun(stdlib::TeXoperator(" \\cup ", args(3), 90, op(args(2)))));
_minus:= funcattr(_minus, "TeX",
    fun(stdlib::TeXoperator(" \\setminus ", args(3), 100, op(args(2)))));
_intersect:= funcattr(_intersect, "TeX",
    fun(stdlib::TeXoperator(" \\cap ", args(3), 110, op(args(2)))));
_fconcat:= funcattr(_fconcat, "TeX",
    fun(stdlib::TeXoperator(" \\circ ", args(3), 140, op(args(2)))));
_concat:= funcattr(_concat, "TeX",
    fun(stdlib::TeXoperator(" \\cdot ", args(3), 170, op(args(2)))));

end_proc():

# end of file #
