# $Date: 1995/03/09 20:49:45 $  $Author: zimmerma $  $Revision: 1.6 $ #

proc()
begin

#++
O -- the domain of order terms of polynomial type

O's are used to represent order terms of series for example. They may
be of polynomial type only.

f(x) = O(g(x)) as x --> x_0 means that there is a constant c with
|f(x)/g(x)| < c as x --> x_0. The limit point x_0 is not mentioned in
the order term. It is up to the user to know which x_0 is meant.
Note that x_0 may not be 'infinity'!

An order term has 1 operand: an expression representing the term. The
expression is simplified by O::simplify to get some crude 'normal form'
(not that is really has a normal form).

The operators +, -, *, 1/ and ^ are defined for order terms. Note that
1/ may cause an error if the operator is not O(1).
++#

O:= domain():
O::name:= "O":
O::info:= "Domain 'O': Big O order terms of series.":
O::interface:= {}:


#--
O::new -- create order term

O::new(e)

e - polynomial expression

Create order term from expression e, which may be a polynomial expression
in several indeterminates. Higher forms of order terms, containing logarithms
for example, can't be defined.
--#

O::new:= proc(x)
    local e;
begin
    if args(0) <> 1 then error("wrong no of args") end_if;

    new(O, O::simplify(x))
end_proc:


#--
O::print -- print order term

O::print(o)

o - order term

An order term is printed as O(...).
--#

O::print:= proc(o)
begin
    hold(O)(extop(o,1))
end_proc:


#--
O::TeX -- return TeX-string for order term

O::TeX(o)

o - order term
--#

O::TeX:= proc(o)
begin
    TeX(hold(O)(extop(o,1)))
end_proc:


#--
O::simplify -- simplify order term

O::simplify(e)

e - expression representing order term

only remove icontent

--#

O::simplify:= proc(x)
begin
   x/O::icontent(x)
end_proc:

O::icontent := proc(x) local i;
begin
   if type(x)="_mult" then
      if type((i:=op(x,nops(x))))=DOM_INT then i else 1 end_if
   elif type(x)=DOM_INT and x<>0 then x
   elif type(x)="_plus" then igcd(O::icontent(op(x,i)) $ i=1..nops(x))
   else 1
   end_if
end_proc:

#--
O::_plus -- add order terms

O::_plus(t1, t2,...)

ti - order terms
--#

O::_plus:= proc()
    local a, b;
begin
    b:= [args()];
    a:= _plus(op(select(b, not O::thisDomain)));
    b:= new(O, O::simplify(_plus(op(map(select(b, O::thisDomain), extop, 1)))));
    if type(a) = "_plus" then  # flat operands of a #
	hold(_plus)(op(a), b)
    elif a = 0 then
	b
    else
	hold(_plus)(a, b)
    end_if
end_proc:


#--
O::negate -- negate order term

O::negate(t)

t - order term
--#

O::negate:= proc(x) begin x end_proc:


#--
O::_mult -- multiply order terms

O::_mult(t1, t2,...)

ti - order terms
--#

O::_mult:= proc()
    local a, b;
begin
    b:= [args()];
    a:= _mult(op(select(b, not O::thisDomain)));
    b:= new(O, O::simplify(_mult(op(map(select(b, O::thisDomain), extop, 1)))));
    if type(a) = "_mult" then  # flat operands of a #
	hold(_mult)(op(a), b)
    elif a = 1 then
	b
    elif a = 0 then
	0
    else
	hold(_mult)(a, b)
    end_if
end_proc:


#--
O::intmult -- multiply order term by integer

O::intmult(t, i)

t - order term
i - integer
--#

O::intmult:= proc(e, i) begin e end_proc:


#--
O::invert -- negate order term

O::invert(t)

t - order term
--#

O::invert:= proc(x)
begin
    O::new(1 / extop(x,1))
end_proc:


#--
O::_power -- power of order term

O::_power(t, p)

t - order term
p - power
--#

O::_power:= proc(x,y)
begin
    new(O, O::simplify(extop(x,1) ^ y))
end_proc:


#--
O::thisDomain -- test if argument if from domain O

O::thisDomain(x)

x - expression
--#

O::thisDomain:= fun(bool(domtype(args(1)) = O)):


#--
O::subs -- substitution

O::subs(x,eq...)
--#

O::subs:= proc(x)
    local i;
begin
    x:= subs(extop(x,1), args(i) $ i=2..args(0));
    if x = 0 then 0 else new(O, O::simplify(x)) end_if
end_proc:


#--
O::diff -- differentiation

O::diff(f,x...)
--#

O::diff:= proc(x)
    local i;
begin
    x:= diff(extop(x,1), args(i) $ i=2..args(0));
    if x = 0 then 0 else new(O, O::simplify(x)) end_if
end_proc:

end_proc():

# end of file #
