# $Date: 1995/02/22 13:02:43 $  $Author: kg $  $Revision: 1.10 $ #
# kg, 10/08/93 #

#++
D -- differential operator

D(f)
D([i1,...,in], f)
D([],f)

f - expression
[i1,...,in] - list of positive integers

D(f) computes the derivative of the function f. D([i],f) computes the
partial derivative of f with respect to its i-th argument. D([i,j],f)
is equivalent to D([i],D([j],f)).
++#

D:= proc()
    local idx, f, x, mapD, i, n, nidx;
begin
    if args(0) = 1 then
	idx:= null(); nidx:= 1; f:= args(1); mapD:= D;
    elif args(0) = 2 then
	idx:= args(1);
	if domtype(idx) = DOM_LIST then
	    idx:= sort(idx)
	else
	    error("invalid indices")
	end_if;
	nidx:= nops(idx);
	f:= args(2);
	mapD:= proc(f,idx) begin D(idx,f) end_proc;
    else error("wrong no of args") end_if;

    if nidx = 0 then return(f) end_if;
    if testargs() then
	if domtype(idx) = DOM_LIST then
	    if not testtype(idx, Type::ListOf(Type::PosInt)) then
		error("indices must be positive integers")
	    end_if
	end_if
    end_if;

    case domtype(f)
    of DOM_LIST do
    of DOM_SET do
    of DOM_TABLE do
    of DOM_ARRAY do
	return(map(f, mapD, idx))

    of DOM_EXPR do
	break;

    of DOM_POLY do
	return(Dpoly(idx, f));

    of DOM_PROC do
	x:= op(f,1);
	if domtype(idx) = DOM_LIST then
	    if max(op(idx)) > nops([x]) then
		error("procedure hasn't that much unknowns")
	    end_if;
	    if nops(x) = 1 then
		return(eval(subsop(hold(func(f,x)),
			1=diff(f(x), x $ nops(idx)), 2=x)));
	    else
		return(eval(subsop(hold(func(f,x)),
			1=diff(f(x), x[idx[i]] $ i=1..nops(idx)), 2=x)));
	    end_if
	end_if;
	if nops([x]) <> 1 then
	    error("procedure has more than one argument")
	end_if;
	return(eval(subsop(hold(func(f,x)), 1=diff(f(x), x), 2=x)));

    of DOM_EXEC do
    	if domtype(idx) <> DOM_LIST then
	    x:= genident();
	    return(eval(subsop(hold(func(f,x)), 1=diff(f(x), x), 2=x)));
	end_if;
	return(procname(idx, f));

    of DOM_FUNC_ENV do
	if funcattr(f, "D") <> FAIL then
	    return(funcattr(f, "D")(idx, f))
	end_if;
	if contains({DOM_PROC, DOM_EXEC}, domtype(op(f,1))) then
	    return(D(idx, op(f,1)))
	end_if;
	if domtype(idx) <> DOM_LIST then
	    x:= genident();
	    return(eval(subsop(hold(func(f,x)), 1=diff(f(x), x), 2=x)));
	end_if;
	#FALL THROUGH#

    of DOM_IDENT do
	return(procname(idx, f));

    otherwise
	return((if f::D <> FAIL then f::D else procname end_if)(idx, f));
    end_case;

    if nidx = 1 then
	case type(f)
	of "_plus" do
	    return(map(f, mapD, idx));

	of "_mult" do
	    return(_plus(subsop(f, i=D(idx,op(f,i))) $ i=1..nops(f)));

	of "_power" do
	    if testtype(op(f,2), NUMERIC) then
		return(op(f,2)*D(idx, op(f,1))*op(f,1)^(op(f,2)-1));
	    end_if;
	    return(procname(idx, f));

	of "_fconcat" do
	    n:= nops(f);
	    return(_mult(D(idx, op(f,n)),
			 (_fconcat(D(op(f,i)), op(f, i+1..n))
			  $ i=1..n-1)));
	end_case;
    else
	case type(f)
	of "_plus" do
	    return(map(f, mapD, idx));

	of "_mult" do
	    x:= idx[1];
	    idx[1]:= NIL;
	    return(D([x], _plus(subsop(f, i=D(idx,op(f,i))) $ i=1..nops(f))));

	of "_power" do
	    if testtype(op(f,2), NUMERIC) then
		x:= idx[1];
		idx[1]:= NIL;
		return(D([x], op(f,2)*D(idx, op(f,1))*op(f,1)^(op(f,2)-1)));
	    end_if;
	    return(procname(idx, f));

	of "_fconcat" do
	    n:= nops(f);
	    x:= idx[1];
	    idx[1]:= NIL;
	    return(D([x], _mult(D(idx, op(f,n)),
			  (_fconcat(D(op(f,i)), op(f, i+1..n))
			  $ i=1..n-1))));
	end_case;
    end_if;

    if domtype(idx) = DOM_LIST then
	if type(op(f,0)) = "D" then
	    if nops(f) = 2 then
		if domtype(op(f,1)) = DOM_LIST then
		    return(procname(sort(idx.op(f,1)), op(f,2)))
		end_if
	    end_if
	end_if
    end_if;

    procname(idx, f)
end_proc:

D:= funcattr(D, "type", "D"):
D:= funcattr(D, "print", "D"):

# end of file #
