
# ok, 21/01/94 #

#++
The Riemann Zeta function

zeta(x)

x - an expression
++#

zeta := proc(x)

begin
    if x::zeta <> FAIL then return(x::zeta(args())) end_if;

    if args(0) <> 1 then
       error("1 argument expected.");
    end_if;

    case domtype(x) 

      of DOM_FLOAT do

	 return( funcattr(zeta, "float")(x) );

      of DOM_INT do

        if x < 0 then
           if x mod 2 = 0 then 
              return ( 0 )
           elif -x < 100 then # See apendix #
	      return( -bernoulli(1-x) / (1-x) )
           end_if
        elif x > 0 then
	     if x mod 2 = 0 and x <= 100 then # See apendix #
                return( 1/2*(2*PI)^x*abs(bernoulli(x))/fact(x) )
	     elif x = 1 then
                error("singularity encountered.")
	     end_if
	else
	     return( -1/2 )
	end_if;

	break;

      of DOM_COMPLEX do

        if domtype(op(x, 1)) = DOM_FLOAT or domtype(op(x, 2)) = DOM_FLOAT then
           return( funcattr(zeta, "float")(x) );
	end_if;
        break;

     end_case;

     procname(x)
end_proc:

zeta:= funcattr(zeta, "print", "zeta"):
zeta:= funcattr(zeta, "info", "zeta -- the Riemann zeta function [try ?zeta for details]"):

# Due to the complexity to compute the nth Bernoulli #
# number, compute bernoulli(n) only if n-1 <= 100    #
