# $Date: 1995/06/08 11:18:04 $ $Author: frankp $ $Revision: 1.9 $ #

# kg, 13/01/94 #

#++
tanh -- the hyperbolic tangens

tanh(x)

x - expression
++#

tanh:= proc(x)
    local f;
    name tanh;
begin
    if x::tanh <> FAIL then return(x::tanh(args())) end_if;
    if args(0) <> 1 then error("wrong no of args") end_if;

    case type(x)
    of DOM_INT do
    of DOM_RAT do
	if x < 0 then return(-tanh(-x)) end_if;
	break;
    
    of DOM_FLOAT do
	return(funcattr(tanh,"float")(x));

    of DOM_COMPLEX do
	if domtype(op(x,1)) = DOM_FLOAT or
	   domtype(op(x,2)) = DOM_FLOAT then
	    return(funcattr(tanh,"float")(x))
	end_if;
	break;

    of "_mult" do
	f:= op(x, nops(x));
	if testtype(f, Type::RealNum) then
	    if f < 0 then return(-tanh(-x)) end_if;
	end_if;
	break;

    end_case;

    procname(x)
end_proc:

tanh:= funcattr(tanh, "info", "tanh -- the hyperbolic tangent"):

tanh:= funcattr(tanh, "print", "tanh"):

tanh:= funcattr(tanh, "diff", proc(e)
    local i;
begin
    e:= op(e,1); diff(e, args(i) $ i=2..args(0)) / cosh(e)^2
end_proc):

tanh:= funcattr(tanh, "expand", fun(expand(sinh(args(1))/cosh(args(1)))) ):

tanh:= funcattr( tanh, "conjugate", fun((
    conjugate(args(1));
    if type(%) = "conjugate" then hold(tanh)(%)
    else tanh(%)
    end_if
)) ):

tanh(0):= 0:

# end of file #
