# $Date: 1995/06/08 11:18:04 $ $Author: frankp $ $Revision: 1.11 $ #

# kg, 13/01/94 #

#++
tan -- the tangens

tan(x)

x - expression
++#

tan:= proc(x)
    local f;
    name tan;
begin
    if x::tan <> FAIL then return(x::tan(args())) end_if;
    if args(0) <> 1 then error("wrong no of args") end_if;

    case type(x)
    of DOM_INT do
    of DOM_RAT do
	if x < 0 then return(-tan(-x)) end_if;
	break;
    
    of DOM_FLOAT do
	return(funcattr(tan,"float")(x));

    of DOM_COMPLEX do
	if domtype(op(x,1)) = DOM_FLOAT or
           domtype(op(x,2)) = DOM_FLOAT then
	       return(funcattr(tan,"float")(x))
	   end_if;
	if op(x,1) = 0 then return(tanh(-x*I)*I) end_if;
	break;

    of "_mult" do
	f:= op(x, nops(x));
	if testtype(f, Type::RealNum) then
	    if f < 0 then return(-tan(-x)) end_if;
	    if domtype(f) = DOM_FLOAT then break end_if;
	else
	    break
	end_if;

	if nops(x) = 2 then
	    if op(x,1) = PI then
		if f < 1/2 then break end_if;
		if f = 1/2 then error("singularity") end_if;
		if f < 1 then return(-tan((1-f)*PI)) end_if;
		if f < 2 then return(tan((f-1)*PI)) end_if;
		return(tan((f-2*(floor(f) div 2))*PI));
	    end_if
	end_if;
	break;

    of "atan" do return(op(x));
    of "asin" do return(op(x) / sqrt(1-op(x)^2));
    of "acos" do return(sqrt(1-op(x)^2) / op(x));
    end_case;

    procname(x)
end_proc:

tan:= funcattr(tan, "print", "tan"):

tan:= funcattr(tan, "diff", proc(e)
    local i;
begin
    e:= op(e,1); diff(e, args(i) $ i=2..args(0)) / cos(e)^2
end_proc):

tan:= funcattr(tan, "expand", fun(expand(sin(args(1))/cos(args(1)))) ):

tan:= funcattr( tan, "conjugate", fun((
    conjugate(args(1));
    if type(%) = "conjugate" then hold(tan)(%)
    else tan(%)
    end_if
)) ):

tan:= funcattr( tan, "info", "tan -- the tangens" ):

tan(0):= 0:
tan(PI/12):= 2-3^(1/2):
tan(PI/8):= 2^(1/2)-1:
tan(PI/6):= (3^(1/2))/3:
tan(PI/4):= 1:
tan(PI/3):= (3^(1/2)):
tan(3*PI/8):= 2^(1/2)+1:
tan(5*PI/12):= 2+3^(1/2):
tan(PI):= 0:
tan(I):= tanh(1)*I:

# end of file #
